unit Unit1;

////////////////////////////////////////////////////////////////////////////////
// (c) 2017-2019  Robert Rozee
////////////////////////////////////////////////////////////////////////////////

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, Math, ComCtrls, ClipBrd, Menus, Registry,
  ScktComp, AppEvnts;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Timer2: TTimer;
    Timer3: TTimer;
    Timer4: TTimer;

    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    FontDialog1: TFontDialog;
    ClientSocket1: TClientSocket;

    PopupMenu1: TPopupMenu;
    Item1A: TMenuItem;                   // connect
    item1B: TMenuItem;                   // disconnect
    Item2A: TMenuItem;                   // LOG to file
    Item2B: TMenuItem;                   // STOP logging
    Item3A: TMenuItem;                   // paste
    Item3A1: TMenuItem;                  //     from clipboard
    Item3A2: TMenuItem;                  //     from text file
    Item3B: TMenuItem;                   // CANCEL paste
    N1: TMenuItem;
    Item4: TMenuItem;                    // screen font
    Item4A: TMenuItem;                   //     font 1
    Item4B: TMenuItem;                   //     font 2
    Item4C: TMenuItem;                   //     font 3
    Item4D: TMenuItem;                   //     font 4
    Item4E: TMenuItem;                   //     font 5
    Item4F: TMenuItem;                   //     font 6
    Item4G: TMenuItem;                   //     font 7
    Item4H: TMenuItem;                   //     font 8
    Item4I: TMenuItem;                   //     font 9
    Item4J: TMenuItem;                   //     font 10
    Item4K: TMenuItem;                   //     manual
    Item5: TMenuItem;                    // font colour
    Item5A: TMenuItem;                   //     red
    Item5B: TMenuItem;                   //     green
    Item5C: TMenuItem;                   //     yellow
    Item5D: TMenuItem;                   //     blue
    Item5E: TMenuItem;                   //     magenta
    Item5F: TMenuItem;                   //     cyan
    Item5G: TMenuItem;                   //     WHITE
    Item6: TMenuItem;                    // dimmable text
    Item6A: TMenuItem;                   //     enabled
    Item6B: TMenuItem;                   //     bright #1
    Item6C: TMenuItem;                   //     bright #2
    Item7: TMenuItem;                    // clear
    Item7A: TMenuItem;                   //     GFX layer
    Item7B: TMenuItem;                   //     text layer
    Item7C: TMenuItem;                   //     ring buffer
    N2: TMenuItem;
    Item8: TMenuItem;                    // select and copy
    Item9: TMenuItem;                    // command window (show)
    N3: TMenuItem;
    Item10: TMenuItem;                   // (c) Robert Rozee  2019

    Panel1: TPanel;
    Image1: TImage;
    Image2: TImage;
    Memo1: TMemo;
    Shape1: TShape;
    Cursor: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    ApplicationEvents1: TApplicationEvents;
    Image3: TImage;

    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure Timer4Timer(Sender: TObject);

    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Panel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);

    procedure PopupMenu1Popup(Sender: TObject);
    procedure Item1Click(Sender: TObject);
    procedure Item2Click(Sender: TObject);
    procedure Item3Click(Sender: TObject);
    procedure Item4Click(Sender: TObject);
    procedure Item5Click(Sender: TObject);
    procedure Item6Click(Sender: TObject);
    procedure Item7Click(Sender: TObject);
    procedure Item8Click(Sender: TObject);
    procedure Item9Click(Sender: TObject);

    procedure ClientSocket1Read(Sender: TObject; Socket: TCustomWinSocket);
    procedure ClientSocket1Error(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure ClientSocket1Disconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ApplicationEvents1Activate(Sender: TObject);
    procedure ApplicationEvents1Deactivate(Sender: TObject);

  private
    { Private declarations }
    procedure CMDialogKey(var Msg: TCMDialogKey); message CM_DIALOGKEY;
    procedure WMSysCommand(var Msg: TWMSysCommand); message WM_SYSCOMMAND;
    procedure WMDeviceChange(var Msg: TMessage); message WM_DEVICECHANGE;
  public
    { Public declarations }
//  procedure WMKeyDown(var Msg: TWMKeyDown); message WM_KEYDOWN;
  end;

var
  Form1: TForm1;

implementation

uses Unit2, Unit3;

{$R *.DFM}
{$R fonts.RES}


procedure TForm1.CMDialogKey(var Msg: TCMDialogKey);   // allows tab and cursor keys to be used
begin                                                  // instead of Form1 intercepting them
  if (Msg.CharCode<>VK_TAB) and                        // for navigation between controls
     (Msg.CharCode<>VK_UP)and (Msg.CharCode<>VK_DOWN) and
     (Msg.CharCode<>VK_LEFT)and (Msg.CharCode<>VK_RIGHT) then inherited
end;

procedure TForm1.WMSysCommand(var Msg: TWMSysCommand); // disable hotkey passthrough
begin                                                  // (alt-keys producing error beep)
  if Msg.CmdType<>SC_KEYMENU then inherited
end;

procedure TForm1.WMDeviceChange(var Msg: TMessage);    // USB device plug and unplug events
begin
//if Form3.CheckBox1.Checked then begin
  Timer4.Enabled:=false;
  Timer4.Enabled:=true;
//                                end;
  inherited
end;


(*
var  hRead_local:THandle;
    hWrite_local:THandle;
     hRead_remote:THandle;
    hWrite_remote:THandle;
*)

const SoftwareKey='\Software\NZ made\GFXterm';
        BuildName='Graphical VT Terminal';
        BuildDate='(build: 11-sept-2019)'; //+'      *** TEST VERSION ***';

const ROWS=24;      // 24 or 36 or 43
      COLS=80;      // limit:1036 pixels max if 1024 pixel wide physical screen

var LogFile:text;

var CommFile:THandle;

const CommName:string='';
      CommRate:integer=0;

var Cursor:TLabel;                       // used as a shortcut to cursor object
       SCR:TCanvas;                      // used as a shortcut to text screen
       GFX:TCanvas;                      // used as a shortcut to graphics screen

const FontIndex:integer=1;               // index of font in FontList, 0=manual
      FGdefault:integer=7;               // default text FG colour
      BGdefault:integer=0;               // default text BG colour
       FGcolour:integer=7;               // text foreground colour
       BGcolour:integer=0;               // text background colour
       TxtStyle:TFontStyles=[];          // text style (underline, bold, etc)
        DimText:boolean=false;           // low intensity flag
        InvText:boolean=false;           // inverse video flag
         DimOpt:integer=0;               // enabled / bright 1 / bright 2
      CursorVis:boolean=true;            // hide/show text cursor
      VTinsMode:boolean=false;           // VT insert / replacement mode

           Xpos:integer=1;               // initial cursor column
           Ypos:integer=1;               // initial cursor row
        Tmargin:integer=1;               // VT100 scroll area top margin
        Bmargin:integer=ROWS;            // VT100 scroll area bottom margin

          lastK:char=#$00;               // last ascii key pressed
          lastC:char=#$00;               // last ascii character printed

         MouseX:integer=-1;              // last mouse X position
         MouseY:integer=-1;              // last mouse Y position

         CRwait:integer=0;               // the number of <CR> characters being waited on
            CLC:integer=0;               // counter of lines added to command log

            TS1:int64=0;                 // timestamp of last serial/network port data read
            TS2:int64=0;                 // timestamp of last serial/network port data write
            TS3:int64=0;                 // timestamp of last VT command decoded
            TS4:int64=0;                 // timestamp of start of connection
            TS5:int64=0;                 // timestamp of start of paste operation
            TE5:int64=0;                 // time (elapsed) for last paste operation
      ErrorText:string='';               // description of error causing a disconnect, etc
      ErrorType:TMsgDlgType=mtCustom;

             PB:record
                  str:string;            // paste buffer (characters to paste)
                  len:integer;           // length of buffer
                  idx:integer            // index into buffer
                end=(str:''; len:0; idx:0);

             RB:record                   // serial input ring buffer
                  data:array [0..65535] of char;
                  head:integer;
                  tail:integer
                end=(head:0; tail:0);

const BreakCounter:integer=-1;           // used to time sending a break
         CONNECTED:integer=0;            // 0 = offline, 1 = USB check,
                                         // 2 = serial,  4 = network
         LOGTOFILE:boolean=false;        // true if logging text to a file
         LOGEXTEND:boolean=false;        // extended logging format: timestamp, hex, etc
         SKIPPRINT:boolean=false;        // buffer overflow, move cursor but no text o/p
//            KILL:boolean=false;        // kill signal to application loop
//            DEAD:boolean=false;        // response from application loop

         MouseMode:integer=0;            // mouse mode and reporting protocol, 0=disabled
     CommandSwitch:integer=0;            // set 1 or 2 to open port on startup

          ACTIVATED:boolean=true;        // true when application has focus (ie, keyboard captured)

var TextStore:array [1..ROWS] of array [1..COLS] of char;

type str255=string[255];

const CPC:array [0..15] of TColor=(clBlack, clNavy, clGreen, clTeal,
                                   clMaroon, clPurple, clOlive, clSilver,
                                   clGray, clBlue, clLime, clAqua,
                                   clRed, clFuchsia, clYellow, clWhite);
{   (dim)           (bright)
0 = Black 	8 = Gray
1 = Blue 	9 = Light Blue
2 = Green 	A = Light Green
3 = Aqua 	B = Light Aqua     (Cyan)
4 = Red 	C = Light Red
5 = Purple 	D = Light Purple   (Magenta)
6 = Yellow 	E = Light Yellow
7 = White 	F = Bright White
}
const CVT:array [0..15] of TColor=(clBlack, clMaroon, clGreen, clOlive,
                                   clNavy, clPurple, clTeal, clSilver,
                                   clGray, clRed, clLime, clYellow,
                                   clBlue, clFuchsia, clAqua, clWhite);

{       (0-7 = dim, 8-15 = bright)
30	Black
31	Red
32	Green
33	Yellow
34	Blue                  TColor($FF8080) = bright blue, as per teraterm
35	Magenta   (Purple)
36	Cyan      (Aqua)
37	White

note: mmbasic should stop using bright-black (gray) for plain
text in the editor, and instead use dim-white (silver)
}

var  PAL:array [0..15] of TColor;              // holds colour palette, normally copied from CVT

var FontHandle:array [1..7] of THandle;        // handles of run-time installed (RAM) fonts

const FontList:array [1..10] of record         // list of preset fonts (7x RT installed fonts)
                                 Name,         //                      (3x windows resident fonts)
                                 Desc:string;
                                 Size:integer
                               end
              =((Name:'BigBlue Terminal 437BM'; Desc:'BigBlue Terminal   8 x 12'; Size:9),
                (Name:'Bm437 IBM EGA8'; Desc:'EGA   8 x 14'; Size:11),
                (Name:'Bm437 IBM EGA9'; Desc:'EGA   9 x 14'; Size:11),
                (Name:'Bm437 IBM VGA8'; Desc:'VGA   8 x 16'; Size:12),
                (Name:'Bm437 IBM VGA9'; Desc:'VGA   9 x 16'; Size:12),
                (Name:'Bm437 IBM ISO8'; Desc:'ISO    8 x 16'; Size:12),
                (Name:'Bm437 IBM ISO9'; Desc:'ISO    9 x 16'; Size:12),
                (Name:'Terminal'; Desc:'Terminal   9pt  (640 x 288)'; Size:9),
                (Name:'Terminal'; Desc:'Terminal 12pt  (960 x 384)'; Size:12),
                (Name:'Terminal'; Desc:'Terminal 14pt  (800 x 432)'; Size:14));


// ##################################remove once new method verified ###########
{
type
  TUSBcheckThread = class(TThread)
  private
  protected
    procedure Execute; override;
  end;

// separate thread used to check if comm port is still alive
procedure TUSBcheckThread.Execute;
var DCB:TDCB;
     ok:boolean;
begin
  DCB.DCBlength:=sizeof(DCB);
  repeat
    sleep(200);

    if CONNECTED=1 then
    begin
      ok:=false;
      try
        if GetCommState(CommFile, DCB) then
        if SetCommState(CommFile, DCB) then ok:=true
      except end;

      if ok then CONNECTED:=2
            else begin
                   try CloseHandle(CommFile); except end;
                   ErrorMsg:='Serial I/O error: USB port unplugged';
                   CONNECTED:=0
                 end
    end
  until false
end;
}


// returns an int64 tick counter, based upon GetTickCount with rollover detection
function GetTickCount64:int64;
const epoch:int64=0;               // ticks over in a tad under 50 days
        DW1:DWORD=0;
var     DW2:DWORD;
begin
  DW2:=GetTickCount;
  if DW2<DW1 then inc(epoch, $100000000);
  DW1:=DW2;
  result:=epoch+DW2
end;

// returns how much time has elapsed since GetTickCount64 was assigned to counter
function timesince(counter:int64):int64;
begin
  result:=GetTickCount64-counter
end;

// from milliseconds input, return days, hours, minutes, seconds in a formatted string
function DHMStime(ms:DWORD):string;
var D,H,M,S:integer;
begin
  D:=ms div (24*60*60*1000);
  dec(ms, D*24*60*60*1000);
  H:=ms div (60*60*1000);
  dec(ms, H*60*60*1000);
  M:=ms div (60*1000);
  dec(ms, M*60*1000);
  S:=ms div 1000;
  if D=1  then result:=format('%d day, %.2dh %.2dm %.2ds',[D, H, M, S]) else
  if D<>0 then result:=format('%d days, %.2dh %.2dm %.2ds',[D, H, M, S]) else
  if H<>0 then result:=format('%dh %.2dm %.2ds',[H, M, S]) else
  if M<>0 then result:=format('%dm %.2ds', [M, S]) else
  if S<>1 then result:=IntToStr(S)+' seconds' else
               result:='1 second'
end;

function StrParity(I:integer):string;
begin
  case I of 0:result:='NONE';
            1:result:='ODD';
            2:result:='EVEN';
            3:result:='MARK';
            4:result:='SPACE'
         else result:=IntToStr(I)
  end  { of case }
end;

function StrStopBits(I:integer):string;
begin
  case I of 0:result:='1 bit';
            1:result:='1.5 bits';
            2:result:='2 bits'
         else result:=IntToStr(I)
  end  { of case }
end;

function pad(I:integer; S:string):string;
begin
  pad:=StringOfChar(' ', I)+S+StringOfChar(' ', I)
end;

procedure LogEXTS(S:string);       // log with timestamp and control characters translated
var H24, M60, S60, ms:word;
                    I:integer;
begin
  try
    DecodeTime(Time, H24, M60, S60, ms);
    writeln(LogFile, Format('%.2dh %.2dm %.2ds %.4dms   %d bytes',[H24, M60, S60, MS, length(S)]));

    for I:=1 to length(S) do
    if S[I]<#32 then case S[I] of #07:write(LogFile,'<BEL>');        // bell
                                  #08:write(LogFile,'<BS>');         // backspace
                                  #09:write(LogFile,'<TAB>');        // tab
                                  #10:write(LogFile,'<LF>');         // linefeed
                                  #13:write(LogFile,'<CR>');         // carriage return
                                  #27:write(LogFile,'<ESC>')         // escape
                               else   write(LogFile, '<', IntToHex(ord(S[I]), 2), '>')
                     end  { of case }
                else write(LogFile, S[I]);

    writeln(LogFile);
    writeln(LogFile)
  except
    try CloseFile(LogFile) except end;
    LOGTOFILE:=false
  end
end;


////////////////////////////////////////////////////////////////////////////////
// the following routines are the text plane primatives. this plane sits
// behind the graphics plane. the following commands are provided:
// putch (x, y, character)              - puts a single character at (x,y)
// gotoxy (x, y)                        - moves cursor to (x,y)
// clear (x1, y1, x2, y2)               - clears a rectangular area
// scroll (x1, y1, x2, y2, direction)   - direction = -1 (down) or +1 (up)
// linescroll(X1, X2, Y1, direction)    - direction = -1 (left) or +1 (right)
// emit (ch)                            - print (ch) at cursor, update cursor
////////////////////////////////////////////////////////////////////////////////

procedure putch(X, Y:integer; ch:char);
var FGmask, BGmask:byte;
begin
  case DimOpt of 0:begin
                     if DimText then FGmask:=$0
                                else FGmask:=$8;
                     BGmask:=$0
                   end;
                 1:begin
                     FGmask:=$8;
                     BGmask:=$0
                   end
              else begin
                     FGmask:=$8;
                     if BGcolour<>0 then BGmask:=$8
                                    else BGmask:=$0
                   end;
  end;  { of case }

  if InvText then begin
                    SCR.Font.Color:=PAL[BGcolour or BGmask];
                    SCR.Brush.Color:=PAL[FGColour or FGmask]
                  end
             else begin
                    SCR.Font.Color:=PAL[FGcolour or FGmask];
                    SCR.Brush.Color:=PAL[BGColour or BGmask]
                  end;
  SCR.Font.Style:=TxtStyle;

  if not SKIPPRINT then
  if Cursor.AutoSize then SCR.TextOut(Cursor.Width*(X-1), Cursor.Height*(Y-1), ch)     // "Terminal", monospaced
                     else begin                                                        // manual font override
                            SCR.FillRect(Rect(Cursor.Width*(X-1), Cursor.Height*(Y-1),
                                              Cursor.Width*(X),   Cursor.Height*(Y)  ));
                            SCR.TextOut(Cursor.Width*(X-1)
                                      +(Cursor.Width-SCR.TextWidth(ch)) div 2,
                                        Cursor.Height*(Y-1), ch)
                          end;

  if (X in [1..COLS]) and (Y in [1..ROWS]) then TextStore[Y, X]:=ch
end;


procedure gotoxy(X, Y:integer);        // -1 indicate no change
begin
  if X<>-1 then
  begin
    Xpos:=X;                           // Xpos = 1 .. ROWS
    if Xpos<1 then Xpos:=1;
    if Xpos>COLS then Xpos:=COLS
  end;

  if Y<>-1 then
  begin
    Ypos:=Y;                           // Ypos = 1 .. COLS
    if Ypos<1 then Ypos:=1;
    if Ypos>ROWS then Ypos:=ROWS
  end;

  Cursor.Tag:=1;                       // flag cursor position as moved
  Cursor.Show                          // ensure cursor is visible after moving
end;


procedure clear(X1, Y1, X2, Y2:integer);
var X, Y:integer;
begin
  if X2<X1 then begin X:=X1; X1:=X2; X2:=X end;
  if Y2<Y1 then begin Y:=Y1; Y1:=Y2; Y2:=Y end;
  X1:=min(COLS, max(X1, 1));                                   // limit range to valid screen
  X2:=min(COLS, max(X2, 1));
  Y1:=min(ROWS, max(Y1, 1));
  Y2:=min(ROWS, max(Y2, 1));

  SCR.Brush.Color:=PAL[BGColour];
  SCR.FillRect(Rect(Cursor.Width*(X1-1), Cursor.Height*(Y1-1),
                    Cursor.Width*(X2),   Cursor.Height*(Y2)  ));

  for Y:=Y1 to Y2 do FillChar(TextStore[Y, X1], X2-X1+1, ' ')
end;


procedure scroll(X1, Y1, X2, Y2, direction:integer);   // +1 = scroll up, -1 = scroll down
var R1, R2:TRect;
      X, Y:integer;
begin
  if X2<X1 then begin X:=X1; X1:=X2; X2:=X end;
  if Y2<Y1 then begin Y:=Y1; Y1:=Y2; Y2:=Y end;
  X1:=min(COLS, max(X1, 1));                                   // limit range to valid screen
  X2:=min(COLS, max(X2, 1));
  Y1:=min(ROWS, max(Y1, 1));
  Y2:=min(ROWS, max(Y2, 1));

  R1:=Rect(Cursor.Width*(X1-1), Cursor.Height*(Y1-1),          // upper rectangle
           Cursor.Width*(X2  ), Cursor.Height*(Y2-1));
  R2:=Rect(Cursor.Width*(X1-1), Cursor.Height*(Y1  ),          // lower rectangle
           Cursor.Width*(X2  ), Cursor.Height*(Y2  ));

  SCR.Brush.Color:=PAL[BGColour];

  case direction of +1:begin                           // scroll screen upwards by 1 line
                         SCR.CopyRect(R1, SCR, R2);    // destination=R1, canvas, source=R2
                         R2.Top:=R1.Bottom;
               //        inc(R2.Bottom);
               //        inc(R2.Right);
                         SCR.FillRect(R2);
                         for Y:=Y1 to Y2-1 do move(TextStore[Y+1, X1], TextStore[Y, X1], X2-X1+1);
                                              //   source,             destination,      count
                         FillChar(TextStore[Y2, X1], X2-X1+1, ' ')     // blank line at bottom
                       end;
                    -1:begin;                          // scroll screen downwards by 1 line
                         SCR.CopyRect(R2, SCR, R1);    // destination=R2, canvas, source=R1
                         R1.Bottom:=R2.Top;    // -1;
               //        inc(R1.Right);
                         SCR.FillRect(R1);
                         for Y:=Y2 downto Y1+1 do move(TextStore[Y-1, X1], TextStore[Y, X1], X2-X1+1);
                                                  //   source,             destination,      count
                         FillChar(TextStore[Y1, X1], X2-X1+1, ' ')     // blank line at top
                       end
                 else ShowMessage('invalid screen scroll value (+1,-1 required)')
  end  { of case }
end;


procedure linescroll(X1, X2, Y1, direction:integer);   // -1 = scroll left, +1 = scroll right
var R1, R2:TRect;
         X:integer;
begin
  if X2<X1 then begin X:=X1; X1:=X2; X2:=X end;
  X1:=min(COLS, max(X1, 1));                                   // limit range to valid screen
  X2:=min(COLS, max(X2, 1));
  Y1:=min(ROWS, max(Y1, 1));

  R1:=Rect(Cursor.Width*(X1-1), Cursor.Height*(Y1-1),          // left rectangle
           Cursor.Width*(X2-1), Cursor.Height*(Y1  ));
  R2:=Rect(Cursor.Width*(X1  ), Cursor.Height*(Y1-1),          // right rectangle
           Cursor.Width*(X2  ), Cursor.Height*(Y1  ));

  SCR.Brush.Color:=PAL[BGColour];

  case direction of -1:begin                           // scroll line left
                         SCR.CopyRect(R1, SCR, R2);    // destination=R1, canvas, source=R2
                         R2.Left:=R1.Right;
                         SCR.FillRect(R2);

                         for X:=X1 to X2-1 do TextStore[Y1,X]:=TextStore[Y1,X+1];
                         TextStore[Y1,X2]:=' '         // blank RHS character
                       end;

                    +1:begin;                          // scroll line right
                         SCR.CopyRect(R2, SCR, R1);    // destination=R2, canvas, source=R1
                         R1.Right:=R2.Left;
                         SCR.FillRect(R1);

                         for X:=X2 downto X1+1 do TextStore[Y1,X]:=TextStore[Y1,X-1];
                         TextStore[Y1,X1]:=' '         // blank LHS character
                       end
                 else ShowMessage('invalid line scroll value (+1,-1 required)')
  end  { of case }
end;


procedure emit(ch:char);
begin
  lastC:=ch;
  if ch<#32 then case ch of #07:windows.beep(440,100);               // bell
                            #08:if Xpos<>1 then dec(Xpos);           // backspace
                            #09:begin
                                  if Xpos>COLS then
                                  begin
                                    Xpos:=1;
                                    inc(Ypos)
                                  end;
                                  repeat                             // tab
                                    putch(Xpos, Ypos, ' ');
                                    inc(Xpos)
                                  until (Xpos-1) mod 8=0
                                end;
                            #10:begin                                // linefeed
                                  inc(Ypos);
                                  if Ypos=Bmargin+1 then
                                  begin
                                    scroll(1, Tmargin, COLS, Bmargin, +1);
                                    Ypos:=Bmargin
                                  end;
                                  if Ypos>ROWS then Ypos:=ROWS
                                end;
                            #13:Xpos:=1;                             // carriage return
                            #17:;                                    // DC 1
                            #18:;                                    // DC 2
                            #19:;                                    // DC 3
                            #20:;                                    // DC 4
                            #27:;                                    // escape
                 end  { of case }
            else begin
                   if Xpos>COLS then
                   begin
//                   windows.beep(880,100);                    // line overrun
                     Xpos:=1;
                     inc(Ypos);
                     if Ypos=Bmargin+1 then
                     begin
                       scroll(1, Tmargin, COLS, Bmargin, +1);
                       Ypos:=Bmargin
                     end;
                     if Ypos>ROWS then Ypos:=ROWS
                   end;

                   if VTinsMode and (Xpos<COLS) then linescroll(Xpos, COLS, Ypos, +1);
                   putch(Xpos, Ypos, ch);
                   inc(Xpos)
                 end;

  if ch in [#8,#9,#10,#13,#32..#255] then
  begin
    Cursor.Tag:=1;                             // flag cursor position as moved
    Cursor.Show;                               // ensure cursor is visible after moving

    if LOGTOFILE and not LOGEXTEND then
    try
      Write(Logfile, ch)                       // write to log file
    except
      try CloseFile(LogFile) except end;
      LOGTOFILE:=false
    end
  end
end;


////////////////////////////////////////////////////////////////////////////////
// the following routines are the graphic plane primatives. this plane sits
// in front of the text plane. the following commands are provided:
// Gw                              - returns width of graphic area
// Gh                              - returns height of graphic area
// GFXclear ((X1, Y1, X2, Y2)      - erase a rectular area
// GFXlineAB (X1, Y1, X2, Y2)      - draw a line from (x1,y1) to (x2,y2)
// GFXarc (X1, Y1, X2, Y2, A1, A2) - draw arc within a rectangle, from
//                                   A1 to A2 degrees; 0 = 12 o'clock
// GFXplot (X, Y)                  - plot a single pixel
// GFXink (R, G, B, width)         - set ink colour and pen width
// GFXfill (X, Y)                  - fill an area we have just enclosed
// GFXmoveto (X, Y)                - set starting location
// DFXdrawto (X, Y)                - draw from previous location to (x,y)
// GFXscroll(X1, Y1, X2, Y2,
//           deltaX, deltaY)       - scroll a graphics area
////////////////////////////////////////////////////////////////////////////////

function Gw:integer;
begin
  result:=Form1.Image2.Picture.Bitmap.Width
end;


function Gh:integer;
begin
  result:=Form1.Image2.Picture.Bitmap.Height
end;


procedure GFXclear(X1, Y1, X2, Y2:integer);
begin
  if X1<X2 then inc(X2)                // +1 as fillrect normally excludes RHS edge
           else inc(X1);
  if Y1<Y2 then inc(Y2)                // +1 as fillrect normally excludes bottom edge
           else inc(Y1);
  GFX.Brush.Color:=clBlack;
  GFX.FillRect(Rect(X1, Y1, X2, Y2))
end;


procedure GFXlineAB(X1, Y1, X2, Y2:integer);
begin
  GFX.MoveTo(X1, Y1);
  GFX.LineTo(X2, Y2)                   // draw line, excluding the last point
//GFX.LineTo(X2, Y2)                   // fill in last point ????????????????
end;


procedure GFXarc(X1, Y1, X2, Y2:integer; A1, A2:single);
var X0, Y0, X3, Y3, X4, Y4:integer;
begin
  A1:=(A1*pi/180.0)-(pi/2.0);            // convert A1 to radians, shift origin ccw 1/4 turn
  A2:=(A2*pi/180.0)-(pi/2.0);            // convert A2 to radians, shift origin ccw 1/4 turn

  X0:=(X1 + X2) div 2;                   // locate centre of elipse: X0
  Y0:=(Y1 + Y2) div 2;                   // locate centre of elipse: Y0

  X3:=X0 + trunc(1000.0*Cos(A2));
  Y3:=Y0 + trunc(1000.0*Sin(A2));
  X4:=X0 + trunc(1000.0*Cos(A1));
  Y4:=Y0 + trunc(1000.0*Sin(A1));

  GFX.Arc(X1, Y1, X2, Y2, X3, Y3, X4, Y4)
end;


procedure GFXplot(X, Y:integer);
begin
  GFX.Pixels[X, Y]:=GFX.Pen.Color
end;


procedure GFXink(R, G, B, width:integer);
begin
  R:=min(255, max(R, 0));
  G:=min(255, max(G, 0));
  B:=min(255, max(B, 0));
  GFX.Pen.Color:=(B*$10000) + (G*$100) + R;
  GFX.Pen.Width:=width
end;


procedure GFXfill(X, Y:integer);
begin
  GFX.Brush.Color:=GFX.Pen.Color;                  // select pen colour as fill
  GFX.FloodFill(X, Y, GFX.Pen.Color, fsBorder);    // fill everything enclosed by pen colour
  GFX.Brush.Color:=clBlack                         // go back to a black brush
(*
  GFX.Brush.Color:=clBlack;                        // select black fill colour
  GFX.FloodFill(X, Y, GFX.Pen.Color, fsBorder);    // fill area bounded by pen colour
  GFX.Brush.Color:=GFX.Pen.Color;                  // select pen colour as fill
  GFX.FloodFill(X, Y, clBlack, fsSurface);         // fill everything we previously set to black
  GFX.Brush.Color:=clBlack                         // go back to a black brush
*)
end;


procedure GFXmoveto(X, Y:integer);
begin
  GFX.MoveTo(X, Y)                                 // set starting point of a multi-line
end;


procedure GFXdrawto(X, Y:integer);
begin
  GFX.LineTo(X, Y)                                 // draw line to (x,y)
end;                                               // excluding the last point

(*
procedure GFXscroll_OLD(X1, Y1, X2, Y2, deltaX, deltaY:integer);
var R1, R2, Fh, Fv:TRect;
begin
  if (deltaX=0) and (deltaY=0) then exit;      // nothing to do!

// R1 is the source rectangle, R2 is the destingation rectangle
  if deltaX<0 then begin                       // moving *** left ***
                     R1.Left:=X1-deltaX;       // - source left side
                     R1.Right:=X2;             // - source right side
                     R2.Left:=X1;              // - destination left side
                     R2.Right:=X2+deltaX;      // - destination right side

                     Fv.Left:=R2.Right+1;
                     Fv.Right:=X2+1            // +1 as fillrect skips right side
                   end
              else begin                       // moving *** right ***
                     R1.Left:=X1;              // - source left side
                     R1.Right:=X2-deltaX;      // - source right side
                     R2.Left:=X1+deltaX;       // - destination left side
                     R2.Right:=X2;             // - destination right side

                     Fv.Left:=X1;
                     Fv.Right:=R2.Left         // fillrect skips right side
                   end;
  Fv.Top:=Y1;
  Fv.Bottom:=Y2+1;                             // +1 as fillrect skips bottom edge

  if deltaY<0 then begin                       // moving *** up ***
                     R1.Top:=Y1-deltaY;        // - source top side
                     R1.Bottom:=Y2;            // - source bottom side
                     R2.Top:=Y1;               // - destination top side
                     R2.Bottom:=Y2+deltaY;     // - destination bottom side

                     Fh.Top:=R2.Bottom+1;
                     Fh.Bottom:=Y2+1           // +1 as fillrect skips bottom edge
                   end
              else begin                       // moving *** down  ***
                     R1.Top:=Y1;               // - source top side
                     R1.Bottom:=Y2-deltaY;     // - source bottom side
                     R2.Top:=Y1+deltaY;        // - destination top side
                     R2.Bottom:=Y2;            // - destination bottom side

                     Fh.Top:=Y1;
                     Fh.Bottom:=R2.Top         // fillrect skips bottom edge
                   end;
  Fh.Left:=X1;
  Fh.Right:=Y2+1;                              // +1 as fillrect skips right side

  GFX.CopyRect(R2, GFX, R1);    // destination=R2, canvas, source=R1

  GFX.Brush.Color:=clBlack;
  if deltaX<>0 then GFX.FillRect(Fv);
  if deltaY<>0 then GFX.FillRect(Fh)
end;
*)

////////////////////////////////////////////////////////////////////////////////
// assumes CopyRect and FillRect both skip right column and bottom row        //
////////////////////////////////////////////////////////////////////////////////

procedure GFXscroll(X1, Y1, X2, Y2, deltaX, deltaY:integer);
var R1, R2, Fh, Fv:TRect;
begin
  if (deltaX=0) and (deltaY=0) then exit;      // nothing to do!

  if X1<X2 then inc(X2)                // +1 as copy/fillrect normally excludes RHS edge
           else inc(X1);
  if Y1<Y2 then inc(Y2)                // +1 as copy/fillrect normally excludes bottom edge
           else inc(Y1);

// R1 is the source rectangle, R2 is the destingation rectangle
  if deltaX<0 then begin                       // moving *** left ***
                     R1.Left:=X1-deltaX;       // - source left side
                     R1.Right:=X2;             // - source right side
                     R2.Left:=X1;              // - destination left side
                     R2.Right:=X2+deltaX;      // - destination right side

                     Fv.Left:=R2.Right;
                     Fv.Right:=X2              // set up vertical strip to clear
                   end
              else begin                       // moving *** right ***
                     R1.Left:=X1;              // - source left side
                     R1.Right:=X2-deltaX;      // - source right side
                     R2.Left:=X1+deltaX;       // - destination left side
                     R2.Right:=X2;             // - destination right side

                     Fv.Left:=X1;
                     Fv.Right:=R2.Left         // set up vertical strip to clear
                   end;
  Fv.Top:=Y1;
  Fv.Bottom:=Y2;                               // set up vertical strip to clear

  if deltaY<0 then begin                       // moving *** up ***
                     R1.Top:=Y1-deltaY;        // - source top side
                     R1.Bottom:=Y2;            // - source bottom side
                     R2.Top:=Y1;               // - destination top side
                     R2.Bottom:=Y2+deltaY;     // - destination bottom side

                     Fh.Top:=R2.Bottom;        // set up horizontal strip to clear
                     Fh.Bottom:=Y2
                   end
              else begin                       // moving *** down  ***
                     R1.Top:=Y1;               // - source top side
                     R1.Bottom:=Y2-deltaY;     // - source bottom side
                     R2.Top:=Y1+deltaY;        // - destination top side
                     R2.Bottom:=Y2;            // - destination bottom side

                     Fh.Top:=Y1;               // set up horizontal strip to clear
                     Fh.Bottom:=R2.Top
                   end;
  Fh.Left:=X1;
  Fh.Right:=Y2;                                // set up horizontal strip to clear

  GFX.CopyRect(R2, GFX, R1);    // destination=R2, canvas, source=R1

  GFX.Brush.Color:=clBlack;
  if deltaX<>0 then GFX.FillRect(Fv);          // if needsbe blank vertical strip
  if deltaY<>0 then GFX.FillRect(Fh)           // if needsbe blank horizontal strip
end;


////////////////////////////////////////////////////////////////////////////////
// the follow are the communications (serial) port routines:
// SetupCommPort (CommPortName, Config:string)
// ReadComm (var S:string[255]):boolean
// WriteComm (S:string[255]);
// CommBytesWaiting:cardinal;
////////////////////////////////////////////////////////////////////////////////

(* the following flags apply to the DCB.Flags field:
const dcb_Binary =              $00000001;     // always 1
      dcb_ParityCheck =         $00000002;
      dcb_OutxCtsFlow =         $00000004;
      dcb_OutxDsrFlow =         $00000008;

      dcb_DtrControlMask =      $00000030;
      dcb_DtrControlDisable =   $00000000;
      dcb_DtrControlEnable =    $00000010;     // TT turns DTR on
      dcb_DtrControlHandshake = $00000020;

      dcb_DsrSensivity =        $00000040;
      dcb_TXContinueOnXoff =    $00000080;
      dcb_OutX =                $00000100;
      dcb_InX =                 $00000200;
      dcb_ErrorChar =           $00000400;
      dcb_NullStrip =           $00000800;

      dcb_RtsControlMask =      $00003000;
      dcb_RtsControlDisable =   $00000000;
      dcb_RtsControlEnable =    $00001000;     // seems to default to 1
      dcb_RtsControlHandshake = $00002000;
      dcb_RtsControlToggle =    $00003000;

      dcb_AbortOnError =        $00004000;
      dcb_Reserveds =           $FFFF8000;
*)

procedure SetupCommPort(CommPortName, Config:string);
var DeviceName:array [0..80] of char;
           DCB:TDCB;
       CommTOs:TCommTimeouts;
         error:DWORD;
          proc:string;
        action:word;
begin
  CONNECTED:=0;
  try CloseHandle(CommFile) except end;
  try
    StrPCopy(DeviceName, copy('\\.\'+CommPortName,1,80));      // 80 characters max
    proc:='CreateFile';
    CommFile:=CreateFile(DeviceName,
                         GENERIC_READ or GENERIC_WRITE,
                         0, Nil,
                         OPEN_EXISTING,
                         FILE_ATTRIBUTE_NORMAL, 0);
    if (CommFile=INVALID_HANDLE_VALUE) then
    begin
      error:=GetLastError;
      MessageDlg('Serial I/O error: '+proc+' failed'+#13+
                 '('+IntToStr(error)+')  "'+SysErrorMessage(error)+'"',
                 mtError, [mbOk], 0);
      exit
    end;

    proc:='SetupComm';
    while not SetupComm(CommFile, 32768, 1024) do
    begin
      error:=GetLastError;
      action:=MessageDlg('Serial I/O error: '+proc+' failed'+#13+
                         '('+IntToStr(error)+')  "'+SysErrorMessage(error)+'"',
                         mtWarning, mbAbortRetryIgnore, 0);
      case action of mrIgnore:break;
                      mrRetry:begin end
                  else        begin
                                try CloseHandle(CommFile) except end;
                                exit
                              end
      end  { of case }
    end;
(*
    proc:='GetCommState';
    DCB.DCBlength:=sizeof(DCB);
    while not GetCommState(CommFile, DCB) do
    begin
      error:=GetLastError;
      action:=MessageDlg('Serial I/O error: '+proc+' failed'+#13+
                         '('+IntToStr(error)+')  "'+SysErrorMessage(error)+'"',
                         mtWarning, mbAbortRetryIgnore, 0);
      case action of mrIgnore:break;
                      mrRetry:begin end
                  else        begin
                                try CloseHandle(CommFile) except end;
                                exit
                              end
      end  { of case }
    end;

    with DCB do
    ShowMessage('DCB retrieved'+#13+
    'length = '+IntToStr(DCBlength)+#13+
    'baudrate = '+IntToStr(BaudRate)+#13+
    'flags = 0x'+IntToHex(Flags, 4)+#13+
    'reserved = '+IntToStr(wReserved)+#13+
    'XON limit = '+IntToStr(XonLim)+#13+
    'XOFF limit = '+IntToStr(XoffLim)+#13+
    'data bits = '+IntToStr(ByteSize)+#13+
    'parity = '+StrParity(Parity)+#13+
    'stop bits = '+StrStopBits(StopBits)+#13+
    'XON char = '+IntToStr(ord(XonChar))+#13+
    'XOFF char = '+IntToStr(ord(XoffChar))+#13+
    'error char = '+IntToStr(ord(ErrorChar))+#13+
    'EOF char = '+IntToStr(ord(EofChar))+#13+
    'event char = '+IntToStr(ord(EvtChar))+#13+
    'reserved = '+IntToStr(wReserved1)+#13+
    StringOfChar(' ', 48));
*)
    fillchar(DCB, sizeof(DCB), 0);             // zero everything in DCB
    DCB.DCBlength:=sizeof(DCB);                // fill in DCB size parameter
    DCB.Flags:=$0001;                          // select binary transfer mode

    //  Config:='baud='+IntToStr(38400)+' parity=n data=8 stop=1'#0;   // port parameters
    Config:=Config+#0;

    proc:='BuildCommDCB';
    while not BuildCommDCB(@Config[1], DCB) do
    begin
      error:=GetLastError;
      action:=MessageDlg('Serial I/O error: '+proc+' failed'+#13+
                         '('+IntToStr(error)+')  "'+SysErrorMessage(error)+'"',
                         mtWarning, mbAbortRetryIgnore, 0);
      case action of mrIgnore:break;
                      mrRetry:begin end
                  else        begin
                                try CloseHandle(CommFile) except end;
                                exit
                              end
      end  { of case }
    end;
(*
    with DCB do
    ShowMessage('updated DCB'+#13+
    'length = '+IntToStr(DCBlength)+#13+
    'baudrate = '+IntToStr(BaudRate)+#13+
    'flags = 0x'+IntToHex(Flags, 4)+#13+
    'reserved = '+IntToStr(wReserved)+#13+
    'XON limit = '+IntToStr(XonLim)+#13+
    'XOFF limit = '+IntToStr(XoffLim)+#13+
    'data bits = '+IntToStr(ByteSize)+#13+
    'parity = '+StrParity(Parity)+#13+
    'stop bits = '+StrStopBits(StopBits)+#13+
    'XON char = '+IntToStr(ord(XonChar))+#13+
    'XOFF char = '+IntToStr(ord(XoffChar))+#13+
    'error char = '+IntToStr(ord(ErrorChar))+#13+
    'EOF char = '+IntToStr(ord(EofChar))+#13+
    'event char = '+IntToStr(ord(EvtChar))+#13+
    'reserved = '+IntToStr(wReserved1)+#13+
    StringOfChar(' ', 48));
*)
    proc:='SetCommState';
    while not SetCommState(CommFile, DCB) do
    begin
      error:=GetLastError;
      action:=MessageDlg('Serial I/O error: '+proc+' failed'+#13+
                         '('+IntToStr(error)+')  "'+SysErrorMessage(error)+'"',
                         mtWarning, mbAbortRetryIgnore, 0);
      case action of mrIgnore:break;
                      mrRetry:begin end
                  else        begin
                                try CloseHandle(CommFile) except end;
                                exit
                              end
      end  { of case }
    end;

    with CommTOs do
    begin
      ReadIntervalTimeout:=MAXDWORD;           // 1  // 10  // 0
      ReadTotalTimeoutMultiplier:=0;           // 0  // 0
      ReadTotalTimeoutConstant:=0;             // 1  // 10  // 300
      WriteTotalTimeoutMultiplier:=0;          // 0  // 0
      WriteTotalTimeoutConstant:=0             // 0  // 10  // 300
    end;

    proc:='SetCommTimeouts';
    while not SetCommTimeouts(CommFile, CommTOs) do
    begin
      error:=GetLastError;
      action:=MessageDlg('Serial I/O error: '+proc+' failed'+#13+
                         '('+IntToStr(error)+')  "'+SysErrorMessage(error)+'"',
                         mtWarning, mbAbortRetryIgnore, 0);
      case action of mrIgnore:break;
                      mrRetry:begin end
                  else        begin
                                try CloseHandle(CommFile) except end;
                                exit
                              end
      end  { of case }
    end

  except
    try CloseHandle(CommFile); except end;
    MessageDlg('Serial I/O error: '+proc+' exception',
               mtError, [mbOk], 0);
    exit
  end;

  TS1:=GetTickCount64;
  TS2:=TS1;
  TS3:=TS2;
  TS4:=TS3;
  CommName:=CommPortName;
  CommRate:=DCB.BaudRate;
  CONNECTED:=2
end;


function ReadComm(var S:str255):boolean;
const lock:boolean=false;
var get, got, error, reason:DWORD;
                   CommStat:TComStat;
begin
  result:=false;
  if lock or (CONNECTED<>2) then exit;
  lock:=true;

  try
    if not ClearCommError(CommFile, reason, @CommStat) then
    begin
      CONNECTED:=0;
      error:=GetLastError;
      try CloseHandle(CommFile); except end;

      ErrorType:=mtError;
      ErrorText:='Serial I/O error: ClearCommError failed  ('+IntToStr(error)+')'+#13+
                 #13+
                 'If you are using a USB to serial bridge,     '+#13+
                 'please check that the USB cable has not      '+#13+
                 'been unplugged.';
      lock:=false;
      exit
    end
  except
    CONNECTED:=0;
    try CloseHandle(CommFile); except end;

    ErrorType:=mtError;
    ErrorText:='Serial I/O error: ClearCommError exception'+#13+
               #13+
               'If you are using a USB to serial bridge,     '+#13+
               'please check that the USB cable has not      '+#13+
               'been unplugged.';
    lock:=false;
    exit
  end;

  get:=min(CommStat.cbInQue, sizeof(S)-1 );          // number of characters waiting

  if get=0 then got:=0 else                          // skip ReadFile if nothing waiting
  try
    if not ReadFile(CommFile, S[1], get, got, nil) then
    begin
      CONNECTED:=0;
      error:=GetLastError;
      try CloseHandle(CommFile); except end;

      ErrorType:=mtError;
      ErrorText:='Serial I/O error: ReadFile failed  ('+IntToStr(error)+')'+#13+
                 #13+
                 'If you are using a USB to serial bridge,     '+#13+
                 'please check that the USB cable has not      '+#13+
                 'been unplugged.';
      lock:=false;
      exit
    end
  except
    CONNECTED:=0;
    try CloseHandle(CommFile); except end;

    ErrorType:=mtError;
    ErrorText:='Serial I/O error: ReadFile exception'+#13+
               #13+
               'If you are using a USB to serial bridge,     '+#13+
               'please check that the USB cable has not      '+#13+
               'been unplugged.';
    lock:=false;
    exit
  end;

  if got<>0 then
  begin
    SetLength(S, got);
    TS1:=GetTickCount64;
    result:=true;
    if LOGEXTEND and LOGTOFILE then LogEXTS(S)
  end;
  lock:=false
end;


function WriteComm(S:str255):boolean;
const lock:boolean=false;
var put, error:DWORD;
begin
  result:=false;
  if lock or (CONNECTED<>2) then exit;
  lock:=true;

  try
    if not WriteFile(CommFile, S[1], length(S), put, nil) then
    begin
      CONNECTED:=0;
      error:=GetLastError;
      try CloseHandle(CommFile); except end;

      ErrorType:=mtError;
      ErrorText:='Serial I/O error: WriteFile failed  ('+IntToStr(error)+')'+#13+
                 #13+
                 'If you are using a USB to serial bridge,     '+#13+
                 'please check that the USB cable has not      '+#13+
                 'been unplugged.';
      lock:=false;
      exit
    end
  except
    CONNECTED:=0;
    try CloseHandle(CommFile); except end;

    ErrorType:=mtError;
    ErrorText:='Serial I/O error: WriteFile exception'+#13+
               #13+
               'If you are using a USB to serial bridge,     '+#13+
               'please check that the USB cable has not      '+#13+
               'been unplugged.';
    lock:=false;
    exit
  end;

  TS2:=GetTickCount64;
  result:=true;
  lock:=false
end;

(*
function CommBytesWaiting:cardinal;
var CommStat:TComStat;
      Errors:cardinal;
begin
  try
    if ClearCommError(CommFile, Errors, @CommStat) then result:=CommStat.cbInQue
                                                   else begin
                                                          result:=0;
                                                          ShowMessage('CCE returned 0')
                                                        end
  except
    result:=0;
    ShowMessage('CCE exception')
  end
end;
*)

////////////////////////////////////////////////////////////////////////////////
// Routines Specific to Network Connection
// =======================================
////////////////////////////////////////////////////////////////////////////////

function WriteSocket(S:string):boolean;
begin
  if not Form1.ClientSocket1.Active then result:=false else
  begin
    Form1.ClientSocket1.Socket.SendText(S);
    TS2:=GetTickCount64;
    result:=true
  end
end;


procedure TForm1.ClientSocket1Read(Sender: TObject; Socket: TCustomWinSocket);
var {H24, M60, S60, ms:word;}
                  I,J:integer;
                    S:string;
begin
  S:=Socket.ReceiveText;                               // grab received data
  for I:=1 to length(S) do
  begin
    J:=(RB.head+1) mod sizeof(RB.data);                // get next free slot in ring buffer
    if J<>RB.tail then                                 // if no buffer overflow...
    begin

///////////////////////////////////////////////////////////////////////////////////////////////////////
      if (S[I]=#10) and (CRwait<>0) then dec(CRwait);  // <LF> handshake
///////////////////////////////////////////////////////////////////////////////////////////////////////

      RB.data[RB.head]:=S[I];                          // add character into ring buffer
      RB.head:=J                                       // update head
    end
  end;

  TS1:=GetTickCount64;
  if LOGEXTEND and LOGTOFILE then LogEXTS(S)
end;


procedure TForm1.ClientSocket1Disconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
//  ShowMessage('socket disconnect event')
end;


const NetworkErrorFlag:boolean=false;
      NetworkSearching:boolean=false;


procedure TForm1.ClientSocket1Error(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
var S:string;
begin
  case ErrorEvent of eeDisconnect:S:='Network I/O error: closing connection to server failed';
                        eeConnect:S:='Network I/O error: locating or connecting to server failed';
                           eeSend:S:='Network I/O error: writing to the socket failed';
                        eeReceive:S:='Network I/O error: reading from the socket failed';
                         eeAccept:S:='Network I/O error: (local) failure to accept a connection';
                        eeGeneral:S:='Network I/O error: a general socket error has occurred'
                  else            S:='Network I/O error: an unknown type of error has occurred'
  end;  { of case }

  S:=S+#13+'('+IntToStr(ErrorCode)+')  "'+SysErrorMessage(ErrorCode)+'"';
  if not NetworkSearching then S:=S+#13+#13+
                                    'connected for '+DHMStime(timesince(TS4))+#13+
                                    'last RxD was '+DHMStime(timesince(TS1))+' ago'+#13+
                                    'last TxD was '+DHMStime(timesince(TS2))+' ago';
  ErrorType:=mtError;
  ErrorText:=S;

  if CONNECTED=4 then CONNECTED:=0;
  try ClientSocket1.Close except end;
  NetworkErrorFlag:=true;
  ErrorCode:=0
end;


////////////////////////////////////////////////////////////////////////////////
// the following is a VT100 command processing engine. it takes characters one
// at a time via the parameter 'ch'. normally these are simply passed out
// unaltered as a one character long return string to then be passed onto
// emit(ch).
//
// however, when a VT100 command sequence is detected characters are accumulated
// in the internal string 'VTline'. once matched to a valid VT100 command, the
// command is enacted. while if the string accumulated is detected as invalid,
// the whole string is returned.
////////////////////////////////////////////////////////////////////////////////

function VT100engine(ch:char):str255;
const VTflag:boolean=false;         // internally held flag
      VTline:str255='';             // internally held string
       Xsave:integer=-1;            //  )
       Ysave:integer=-1;            //  )
      FGsave:integer=-1;            //  ) saved values for
      BGsave:integer=-1;            //  ) cursor location
      TSsave:TFontStyles=[];        //  ) and attributes
      DTsave:boolean=false;         //  )
      ITsave:boolean=false;         //  )
var n, v, h, I, J:integer;
             S, T:str255;

  function PC(S:str255):integer;       // returns count of semicolon delimited parameters
  var I, dc, sc:integer;               // or -1 if any invalid characters are found
  begin
    if length(S)=0 then PC:=0 else     // empty string -> no parameters
    begin
      dc:=0;                           // number of digits
      sc:=0;                           // number of semicolon delimiters
      for I:=1 to length(S) do
      begin
        if S[I] in ['0'..'9'] then inc(dc);
        if S[I]=';' then inc(sc);
      end;
      if (dc+sc)<>length(S) then PC:=-1        // invalid characters found
                            else PC:=sc+1      // number of parameters in S
    end
  end;      // ( 1;2 = 2 parameters, 1;;2 = 3 parameters, ;;; = 4 parameters

  function Pn(S:str255; n:integer):integer;    // returns parameter n as an integer
  var I:integer;
  begin
    while (n>1) and (length(S)<>0) do
    begin
      if pos(';', S)=1 then dec(n);
      delete(S, 1, 1)
    end;
    if (length(S)=0) or (S[1]=';') then Pn:=0 else
    begin
      I:=pos(';', S);
      if I<>0 then S:=copy(S, 1, I-1);
      if length(S)=0 then Pn:=0
                     else try
                            Pn:=StrToInt(S)
                          except
                            Pn:=0              // should never arrive here
                          end
    end
  end;

  function OK(S:str255; var n:integer):boolean;        // returns true if a valid number
  begin                                                // (with number placed in n)
    OK:=true;
    try
      if length(S)=0 then n:=0
                     else n:=StrToInt(S)
    except
      OK:=false
    end
  end;

  procedure fail;              // failed to decode string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
//    if CLC>999 then Lines.Delete(0);
      while Lines.Count>1000 do Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'FAIL: <ESC>'+copy(VTline,2,length(VTline)-1));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    result:=VTline;            // return complete string
    VTline:='';
    VTflag:=false              // drop out of VT100 mode
  end;

  procedure pass;              // sucessfully processed string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
//    if CLC>999 then Lines.Delete(0);
      while Lines.Count>1000 do Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'PASS: <ESC>'+copy(VTline,2,length(VTline)-1));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    VTline:='';
    VTflag:=false;             // drop out of VT100 mode
    TS3:=GetTickCount64
  end;

begin
  if ch=#27 then VTflag:=true;
  if not VTflag then result:=ch else
  begin
    result:='';
    VTline:=VTline+ch;
    if length(VTline)=1 then exit;

    if length(VTline)>250 then fail            // way too long an escape sequence!
    else
    if pos(#27+'[', VTline)=1 then             // try to process a complete <esc>[ string
    begin
      if length(VTline)=2 then exit;           // still building command string
      if ch in ['0'..'9',';','?'] then exit;   // still building command string

      S:=copy(VTline, 3, length(VTline)-3);    // extract parameter segment

      case ch of 'A':begin                     // move cursor up n lines
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('UP '+IntToStr(n));
                         if n=0 then n:=1;
                         if Ypos<Tmargin then gotoxy(-1, Ypos-n)
                                         else gotoxy(-1, max(Ypos-n, Tmargin));
                         pass
                       end
                     end;

                 'B':begin                     // move cursor down n lines
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('DOWN '+IntToStr(n));
                         if n=0 then n:=1;
                         if Ypos>Bmargin then gotoxy(-1, Ypos+n)
                                         else gotoxy(-1, min(Ypos+n, Bmargin));
                         pass
                       end
                     end;

                 'C':begin                     // move cursor right n columns
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('RIGHT '+IntToStr(n));
                         if n=0 then n:=1;
                         gotoxy(Xpos+n, -1);
                         pass
                       end
                     end;

                 'D':begin                     // move cursor left n columns
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('LEFT '+IntToStr(n));
                         if n=0 then n:=1;
                         gotoxy(Xpos-n, -1);
                         pass
                       end
                     end;

             'H','f':begin                     // position cursor (ignores Tmargin and Bmargin)
                       n:=PC(S);
//                     ShowMessage('position cursor |'+S+'|'+VTline+'| '+IntToStr(n));
                       case n of 0:begin
                                     gotoxy(1, 1);
//                                   ShowMessage('top left');
                                     pass
                                   end;
                                 1:begin
                                     v:=Pn(S,1);
                                     if v=0 then v:=1;
                                     gotoxy(1, v);
                                     pass
                                   end;
                                 2:begin
                                     v:=Pn(S,1);
                                     h:=Pn(S,2);
                                     if v=0 then v:=1;
                                     if h=0 then h:=1;
                                     gotoxy(h, v);
//                                   ShowMessage('row = '+IntToStr(v)+'  col = '+IntToStr(h));
                                     pass
                                   end
                              else fail
                       end  { of case }
                     end;

                 'J':if not OK(S, n) then fail else    // clear screen above/below cursor
                     case n of 0:begin                 // clear cursor to end of screen
                                   clear(Xpos, Ypos, COLS, Ypos);
                                   if Ypos<ROWS then clear(1, Ypos+1, COLS, ROWS);
                                   pass
                                 end;
                               1:begin                 // clear start of screen to cursor
                                   if Ypos>1 then clear(1, 1, COLS, Ypos-1);
                                   clear(1, Ypos, Xpos, Ypos);
                                   pass
                                 end;
                               2:begin                 // clear whole screen
                                   clear(1, 1, COLS, ROWS);
//                                 gotoxy(1, 1);       // ANSI std *may* specify home cursor
                                   pass                // VT100 manual says cursor DOES NOT MOVE
                                 end
                            else fail
                     end;  { of case }

                 'K':if not OK(S, n) then fail else    // clear line to left/right of cursor
                     case n of 0:begin                 // clear cursor to EOL
                                   clear(Xpos, Ypos, COLS, Ypos);
                                   pass
                                 end;
                               1:begin                 // clear SOL to cursor
                                   clear(1, Ypos, Xpos, Ypos);
                                   pass
                                 end;
                               2:begin                 // clear whole line
                                   clear(1, Ypos, COLS, Ypos);
                                   pass
                                 end
                                else fail
                     end;  { of case }

// ######## VT102 edit commands (start)

                 'P':if not OK(S, n) then fail else    // delete character under cursor
                     begin
                       if n=0 then n:=1;
                       for I:=1 to n do linescroll(Xpos, COLS, Ypos, -1);
                       pass
                     end;

                 'M':if not OK(S, n) then fail else    // delete line and scroll screen up
                     if Ypos in [Tmargin..Bmargin] then
                     begin
                       if n=0 then n:=1;
                       for I:=1 to n do scroll(1, Ypos, COLS, Bmargin, +1);
                       pass
                     end;

                 'L':if not OK(S, n) then fail else    // insert line and scroll screen down
                     if Ypos in [Tmargin..Bmargin] then
                     begin
                       if n=0 then n:=1;
                       for I:=1 to n do scroll(1, Ypos, COLS, Bmargin, -1);
                       pass
                     end;

// ######## VT102 edit commands (end)

                 'm':begin                             // set up character colours and attributes
                       if S='' then S:='0';
                       n:=PC(S);
//                     ShowMessage(IntToStr(n)+'  |'+S+'|');
                       if n=-1 then fail else
                       begin
                         for I:=1 to n do
                         begin
                           J:= Pn(S,I);
                           case J of 0:begin
//                                       ShowMessage('reset colours and attributes');
                                         DimText:=false;
                                         InvText:=false;
                                         TxtStyle:=[];
                                         FGcolour:=FGdefault;
                                         BGcolour:=BGdefault
                                       end;
                                     1:TxtStyle:= TxtStyle+[fsBold];       // bold
                                     2:DimText:=true;                      // dim FGcolour
                                     4:TxtStyle:=TxtStyle+[fsUnderline];   // underline
                                     5:begin end;                          // (not supported)
                                     7:InvText:=true;                      // reverse video
                                30..37:FGcolour:=J-30;
                                    39:FGcolour:=FGdefault;
                                40..47:BGcolour:=J-40;
                                    49:BGcolour:=BGdefault
                           end  { of case }
                         end;
                         pass
                       end
                     end;

                 'n':if not OK(S, n) then fail else
                     if n<>6 then fail else
                     begin                             // return cursor row and column
//                     ShowMessage('cursor position requested');
                       T:=#27+'['+IntToStr(Ypos)+';'+IntToStr(Xpos)+'R';
                       if PB.idx=0 then
                       case CONNECTED of 2:WriteComm(T);
                                         4:WriteSocket(T)
                       end;  { of case }
                       pass
                     end;

                 'r':begin                             // set up scrolling region
                       n:=PC(S);
//                     ShowMessage('set scroll window |'+S+'|'+VTline+'| '+IntToStr(n));
                       case n of 0:begin
                                     Tmargin:=1;
                                     Bmargin:=ROWS;
                                     gotoxy(1, 1);     // VT100 manual specifies home cursor
                                     pass
                                   end;
                                 2:begin
                                     I:=max(Pn(S,1), 1);
                                     J:=min(Pn(S,2), ROWS);
                                     if (I<J)then begin
                                                    Tmargin:=I;
                                                    Bmargin:=J
                                                  end;
                                     gotoxy(1, 1);     // VT100 manual specifies home cursor
                                     pass
                                   end
                              else fail
                       end  { of case }
                     end;

                 'h':begin                                         // enable feature
                       if S='4'     then VTinsMode:=true else      // select insert mode
                       if S='?9'    then MouseMode:=MouseMode and $FF00 or $0001 else  // X10 flag
                       if S='?1000' then MouseMode:=MouseMode and $FF00 or $0010 else  // VT200 flag
                       if S='?1006' then MouseMode:=MouseMode and $00FF or $0100 else  // SGR flag
                       if S='?1015' then MouseMode:=MouseMode and $00FF or $1000 else  // URXVT flag
                       if S='?25'   then CursorVis:=true else fail;    // show text cursor
                       if VTflag then pass
                     end;

                 'l':begin                                         // disable feature
                       if S='4'     then VTinsMode:=false else     // select replacement mode
                       if S='?9'    then MouseMode:=MouseMode and $FFF0 else   // X10 flag
                       if S='?1000' then MouseMode:=MouseMode and $FF0F else   // VT200 flag
                       if S='?1006' then MouseMode:=MouseMode and $F0FF else   // SGR flag
                       if S='?1015' then MouseMode:=MouseMode and $0FFF else   // URXVT flag
                       if S='?25'   then CursorVis:=false else fail;   // hide text cursor
                       if VTflag then pass
                     end
              else   fail
      end  { of case}
    end
    else

    if pos(#27, VTline)=1 then                 // process a complete <esc> string
    begin
      if length(VTline)=1 then exit;           // still building command string
      if ch='[' then exit;                     // still building command string

//    S:=copy(VTline, 2, length(VTline)-2);    // extract parameter segment

      case ch of '7':begin                     // save cursor position and attributes
                       Xsave:=Xpos;
                       Ysave:=Ypos;
                       FGsave:=FGcolour;
                       BGsave:=BGcolour;
                       TSsave:=TxtStyle;
                       DTsave:=DimText;
                       ITsave:=InvText;
                       pass
                     end;

                 '8':begin                     // restore cursor position and attributes
                       if (Xsave>0) and (Ysave>0) then
                       begin
                         gotoxy(Xsave,Ysave);
                         FGcolour:=FGsave;
                         BGcolour:=BGsave;
                         TxtStyle:=TSsave;
                         DimText:=DTsave;
                         InvText:=ITsave;
                         Xsave:=-1;
                         Ysave:=-1
                       end;
                       pass
                     end;

                 'E':begin                     // same as ESC D (below) followed by CR
                       if Ypos<Bmargin then gotoxy(1,Ypos+1)
                                       else begin
                                              scroll(1, Tmargin, COLS, Bmargin, +1);
                                              gotoxy(1,-1)
                                            end;
                       pass
                     end;

                 'D':begin                     // scroll region up if cursor is at bottom of window
                       if Ypos<Bmargin then gotoxy(-1,Ypos+1)
                                       else scroll(1, Tmargin, COLS, Bmargin, +1);
                       pass
                     end;

                 'M':begin                     // scroll region down if cursor is at top of window
                       if Ypos>Tmargin then gotoxy(-1,Ypos-1)
                                       else scroll(1, Tmargin, COLS, Bmargin, -1);
                       pass
                     end
              else   fail
      end  { of case }
    end else fail
  end
end;


////////////////////////////////////////////////////////////////////////////////
// the following is a GFX command processing engine. it takes characters one
// at a time via the parameter 'ch'. normally these are simply passed out
// unaltered as a one character long return string to then be passed onto
// emit(ch).
//
// however, when a GFX command sequence is detected characters are accumulated
// in the internal string 'GFXline'. once matched to a valid GFX command, the
// command is enacted. while if the string accumulated is detected as invalid,
// the whole string is returned.
////////////////////////////////////////////////////////////////////////////////

function GFXengine(ch:char):str255;
const GFXflag:boolean=false;        // internally held flag
      GFXline:str255='';            // internally held string
      GFXpass:boolean=false;        // true if we've just succeeded in decoding
var params:array[1..16] of integer;
    CMD, S, T, PSn:str255;
           I, J, n:integer;

  procedure fail;             // failed to decode string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
//    if CLC>999 then Lines.Delete(0);
      while Lines.Count>1000 do Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'FAIL: <DLE>'+copy(GFXline,2,length(GFXline)-2));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    result:=GFXline;          // return complete string
    GFXline:='';
    GFXflag:=false            // drop out of GFX mode
  end;

  procedure pass;             // sucessfully processed string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
//    if CLC>999 then Lines.Delete(0);
      while Lines.Count>1000 do Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'PASS: <DLE>'+copy(GFXline,2,length(GFXline)-2));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    if not Form1.Image2.Visible then Form1.Image2.Show;        // turn on graphics layer
                                                               // if not already visible
    GFXline:='';
    GFXflag:=false;                  // drop out of GFX mode
    GFXpass:=true
  end;

begin
  if GFXpass and (ch=#10) then       // supress trailing LF for BASIC compatibility
  begin
    GFXpass:=false;
    result:='';
    exit
  end;

  if ch=#16 then GFXflag:=true;
  if not GFXflag then result:=ch else
  begin
    result:='';
    GFXline:=GFXline+ch;

    if length(GFXline)>250 then begin    // way too long a GFX sequence!
                                  fail;
                                  exit
                                end;

    if (GFXline[1]=#16) and (GFXline[length(GFXline)]=#13) then
    begin                          // process a complete <dle> string
//  format is:  <DLE> Command [,|<TAB>|<SPC>]  Param1 [,|<TAB><SPC>]  Param2... <cr><lf>

      S:=GFXline;

// the below FOR and WHILE loops perform the following:
// - convert every control character, space, comma and semicolon into a TAB
// - convert all groups of consecutive TABs into a single TAB
// - remove any leading TABs from the beginning
// - remove any trailing TABs from the end
      for I:=1 to length(S) do if S[I] in [#00..#32,',',';'] then S[I]:=#09;

      I:=pos(#09#09, S);
      while I<>0 do                // convert pairs of TABs into single TABs
      begin
        delete(S, I, 1);
        I:=pos(#09#09, S)
      end;

      while (length(S)<>0) and (S[1]=#09) do
          delete(S, 1, 1);                     // remove leading TABs
      while (length(S)<>0) and (S[length(S)]=#09) do
          delete(S, length(S), 1);             // remove trailing TABs

      if length(S)=0 then fail;
      if not GFXflag then exit;

// next the command is peeled off the start of the string, and converted to upper case
      I:=pos(#09, S);
      J:=pos('-', S);
      if J<>0 then I:=min(I, J);
      J:=pos('+', S);
      if J<>0 then I:=min(I, J);   // new version, allows '+' or '-' delimiting command

      if I<>0 then begin
                     CMD:=UpperCase(copy(S, 1, I-1));
                     if S[I]<>#09 then dec(I);
                     delete(S, 1, I)
                   end
              else begin
                     CMD:=S;
                     S:=''
                   end;

// now we (1) abbreviate/shorten the command to a single letter, and,
//        (2) decide how many parameters we are expecting to see
      if length(CMD)<>1 then
      if CMD='CLEAR'  then CMD:='C' else
      if CMD='INK'    then CMD:='I' else
      if CMD='LINE'   then CMD:='L' else
      if CMD='PLOT'   then CMD:='P' else
      if CMD='ARC'    then CMD:='A' else
      if CMD='FILL'   then CMD:='F' else
      if CMD='MOVETO' then CMD:='M' else
      if CMD='DRAWTO' then CMD:='D' else
      if CMD='SCROLL' then CMD:='S'
                      else fail;               // failed to identify a long command
      if not GFXflag then exit;

      n:=0;                                    // suppress compiler warning
      case CMD[1] of 'P', 'F', 'M', 'D':n:=2;
                          'C', 'I', 'L':n:=4;
                               'A', 'S':n:=6;
                                    '?':n:=0
                  else                  fail   // failed to identify a short command
      end;  { of case }
      if not GFXflag then exit;

// the next thing to do is to separate out the parameters
      for I:=1 to n do
      begin
        J:=pos(#09, S);
        if J<>0 then begin
                       PSn:=copy(S, 1, J-1);
                       delete(S, 1, J)
                     end
                else begin
                       PSn:=S;
                       S:=''
                     end;

        try
          params[I]:=trunc(StrToFloat(PSn))
        except
          fail;
          exit
        end
      end;

//    if false then
      case CMD[1] of 'C':GFXclear(params[1], params[2], params[3], params[4]);
                     'I':GFXink(params[1], params[2], params[3], params[4]);
                     'L':GFXlineAB(params[1], params[2], params[3], params[4]);
                     'P':GFXplot(params[1], params[2]);
                     'A':GFXarc(params[1], params[2], params[3], params[4], params[5], params[6]);
                     'F':GFXfill(params[1], params[2]);
                     'M':GFXmoveto(params[1], params[2]);
                     'D':GFXdrawto(params[1], params[2]);
                     'S':GFXscroll(params[1], params[2], params[3], params[4], params[5], params[6]);
                     '?':begin
                           T:=IntToStr(Gw)+', '+IntToStr(Gh)+#13;
                           if PB.idx=0 then case CONNECTED of 2:WriteComm(T);
                                                              4:WriteSocket(T)
                                            end  { of case }
                         end
                  else   fail
      end;  { of case }
      if GFXflag then pass
    end  { end of processing a valid GFX command string }
  end
end;


////////////////////////////////////////////////////////////////////////////////
// Timer event handlers (x4)
//
// Timer1: 15mS nominal tick rate
//         flash cursor: 500mS on, 500mS off
//         every 15mS: update status bar and cursor location
//         every 15mS: process incoming serial data into ring buffer
//         handle break signalling to 1455 firmware
// Timer2: 45mS, process ring buffer to screen (max 30mS runtime)
// Timer3: 300ms paste ticker, interval changes to 15ms while pasting
// Timer4: 45ms, one-shot, part of USB connection health test
//
// note: Timer2 may stamp all over the other timers if
//       it needs to process large quantities of data.
////////////////////////////////////////////////////////////////////////////////

procedure TForm1.Timer1Timer(Sender: TObject);
const flag1:boolean=false;
      flag2:boolean=false;
      flag3:integer=-1;
var buffer:str255;                     // (local) serial input buffer
       I64:int64;
       I,J:integer;
         S:string;
begin
// ******** FLASH CURSOR: 500ms on, 500ms off **********************************
// ******** (also check network socket for disconnect) *************************

  flag1:=((GetTickCount mod 1000)<500);
  if flag1<>flag2 then                         // change state every 500ms
  begin
    Cursor.Visible:=CursorVis and (flag1 or (Cursor.Tag=1));
    Cursor.Tag:=0;                             // clear cursor movement flag
    flag2:=flag1;

//  if flag1 and ClientSocket1.Active then try ClientSocket1.Socket.SendText('') except end;
//  ******** the above doesn't work, was an attempt to detect a dropped connection ********

    if (CONNECTED=4) and not ClientSocket1.Active then
    begin
      CONNECTED:=0;
      if timesince(TS4)>5000 then              // only show message if connected for >5 seconds
      begin
        ErrorType:=mtInformation;
        ErrorText:='Network I/O error: connection to server is no longer active'+#13+
                   #13+
                   'connected for '+DHMStime(timesince(TS4))+#13+
                   'last RxD was '+DHMStime(timesince(TS1))+' ago'+#13+
                   'last TxD was '+DHMStime(timesince(TS2))+' ago'
      end
    end
  end;

//  if HideCursor then Cursor.Visible:=false;

// ******** UPDATE WINDOW CAPTION and TASKBAR TEXT *****************************
  if CONNECTED<>flag3 then
  begin
    case CONNECTED of 0:begin                          // disconnected
                          Form1.Caption:=BuildName+'   '+BuildDate;
                          Application.Title:='offline';
//                        Label5.Visible:=false;
                          CommName:='';
                          CommRate:=0
                        end;
                      2:begin                          // connected (serial)
                          Form1.Caption:=CommName+':'+
                                      IntToStr(CommRate)+
                                      '   '+BuildName+
                                      '   '+BuildDate;
                          Application.Title:=CommName+':'+IntToStr(CommRate);
                          Label5.Color:=clLime
                        end;
                      4:begin                          // connected (network)
                          Form1.Caption:=ClientSocket1.Host+':'+
                                      IntToStr(ClientSocket1.Port)+
                                      '   '+BuildName+
                                      '   '+BuildDate;
                          Application.Title:=ClientSocket1.Host+':'+
                                             IntToStr(ClientSocket1.Port);
                          Label5.Color:=clYellow
                        end
    end;  { of case }
    flag3:=CONNECTED
  end;

// ******** UPDATE STATUS BAR and CURSOR POSITION ******************************
  S:=Format('%.2x  row=%.2d  col=%.2d  key=%.2x',
            [ord(lastC), Ypos, Xpos, ord(lastK)]);
  if Label1.Caption<>S then Label1.Caption:=S;

  I64:=timesince(TS1);
  if I64<60000   then begin
                        S:=Format('%.5d', [I64]);
                        S:=copy(S,1,2)+'.'+S[3]+'s'
                      end else
  if I64<3600000 then begin
                        S:=Format('%.2d%.5d', [I64 div 60000, I64 mod 60000]);
                        S:=copy(S,1,2)+':'+copy(S,3,2)
                      end else
                      S:=' >1h ';
(*
  S:=Format('%.10d', [I64]);
  if I64<1000  then S:=copy(S,8,2)+'0ms' else
  if I64<60999 then S:=copy(S,6,2)+'.'+S[8]+'s' else
                    S:='>1min';
*)
  if Label2.Caption<>S then Label2.Caption:=S;
  Label2.Visible:=(CONNECTED<>0);              // hide Rx timer if not connected

  I64:=timesince(TS2);
  if I64<60000   then begin
                        S:=Format('%.5d', [I64]);
                        S:=copy(S,1,2)+'.'+S[3]+'s'
                      end else
  if I64<3600000 then begin
                        S:=Format('%.2d%.5d', [I64 div 60000, I64 mod 60000]);
                        S:=copy(S,1,2)+':'+copy(S,3,2)
                      end else
                      S:=' >1h ';
(*
  S:=Format('%.10d', [I64]);
  if I64<1000  then S:=copy(S,8,2)+'0ms' else
  if I64<60999 then S:=copy(S,6,2)+'.'+S[8]+'s' else
                    S:='>1min';
*)
  if Label3.Caption<>S then Label3.Caption:=S;
  Label3.Visible:=(CONNECTED<>0);              // hide Tx timer if not connected

  I:=RB.head-RB.tail;
  if I<0 then I:=I+sizeof(RB.data);
  I:=min(99, (I*100) div sizeof(RB.data));

  if I>98 then SKIPPRINT:=true;
  if I<95 then SKIPPRINT:=false;

  S:=Format('%.2d%%', [I]);                    // %age of (64k) ring buffer used
  if Label4.Caption<>S then
  begin
    Label4.Caption:=S;
    if I<10 then Label4.Color:=clSilver else
    if I<40 then Label4.Color:=clAqua else
    if I<70 then Label4.Color:=clYellow
            else Label4.Color:=clRed
  end;

  Label5.Visible:=(CONNECTED<>0);              // hide 'online' indicator if not connected
  Label6.Visible:=LOGTOFILE;                   // hide 'logging' indicator if not logging

  S:=Format('[%.6d]', [min(999999, max(PB.len-(PB.idx-1), 0))]);
  if Label7.Caption<>S then
  begin
    Label7.Caption:=S;
    if timesince(TS3)>500 then Label7.Color:=clLime
                          else Label7.Color:=clAqua
  end;
  Label7.Visible:=(PB.idx<>0);

  S:=Format('(%.2d,%.2d)', [min(max(MouseX, 1), COLS),
                            min(max(MouseY, 1), ROWS)]);
  if Label8.Caption<>S then Label8.Caption:=S;
//Label8.Visible:=(MouseX>=1) and (MouseX<=COLS) and (MouseY>=1) and (MouseY<=ROWS);

  Cursor.Top :={ Image1.Top+ }  (Cursor.Height*(min(max(Ypos, 1), ROWS)-1));
  Cursor.Left:={ Image1.Left+ } (Cursor.Width* (min(max(Xpos, 1), COLS)-1));

  if Form2.Visible then
  begin
    case MouseMode of $0000:S:=' mouse=off';
                      $0001:S:=' X10';
                      $0010:S:=' VT200';
                      $0101:S:=' X10+SGR';
                      $0110:S:=' VT200+SGR';
                      $1001:S:=' X10+URXVT';
                      $1010:S:=' VT200+URXVT'
                       else S:=' ???'
    end;  { of case }
    if VTinsMode then S:=' ins'+S
                 else S:=' ovr'+S;

//  S:=' INS'+' VT200+URXVT';
//  FG=n  BG=n  TM=nn  BM=nn  ins  VT200+URXVT

//  FG=n BG=n TM=nn BM=nn ins VT200+URXVT

//  FG=n  TM=nn  VT200+URXVT
//  BG=n  BM=nn  INS

    S:=Format('FG=%.1d BG=%.1d TM=%.2d BM=%.2d',
              [FGcolour,BGcolour,Tmargin, Bmargin])+S;
    if Form2.Label1.Caption<>S then Form2.Label1.Caption:=S
  end;

// ******** READ FROM COMM PORT, placing characters into ring buffer ***********
  while (CONNECTED=2) and ReadComm(buffer) do
  begin
    for I:=1 to length(buffer) do
    begin
      J:=(RB.head+1) mod sizeof(RB.data);
      if J<>RB.tail then
      begin
///////////////////////////////////////////////////////////////////////////////////////////////////////
        if (buffer[I]=#10) and (CRwait<>0) then dec(CRwait);   // <LF> handshake
///////////////////////////////////////////////////////////////////////////////////////////////////////
        RB.data[RB.head]:=buffer[I];
        RB.head:=J
      end
    end
  end;

// ******** HANDLE BREAK (alt-B) SIGNALLING :SetCommBreak / ClearCommBreak *****
  if BreakCounter<>-1 then                         // BreakCounter is active
  begin
    if (BreakCounter=0) and (CONNECTED=2) then
    try
      SetCommBreak(CommFile)                       // set break
    except end;
    Inc(BreakCounter, Timer1.Interval);

    if BreakCounter>200 then                       // then after 200mS
    begin
      if CONNECTED=2 then
      try
        ClearCommBreak(CommFile)                   // reset break
      except end;
      BreakCounter:=-1
    end
  end;

//////////////////////////////////////////////////////////////
//  the following line is a very crude way of initiating a  //
//  connection that has been specified on the command line  //
//////////////////////////////////////////////////////////////
  if (CommandSwitch<>0) and (timesince(TS1)>250)then Item1Click(nil);

////////////////////////////////////////////////////////////////
//  the following line ensures that Panel1 always has focus   //
//  when being interacted, and hence that mouse wheel events  //
//  are not disrupted. exceptions are:                        //
//  1. when command window is being interacted with,          //
//  2. the select and copy window (Memo1) is displayed,       //
//  3. the application has not got focus (keyboard input)     //
////////////////////////////////////////////////////////////////
//if not Memo1.Visible then Panel1.SetFocus

  if ACTIVATED and not (Memo1.Visible or
              Form2.RichEdit1.Focused or
                      Panel1.Focused) then Panel1.SetFocus
end;


procedure TForm1.Timer2Timer(Sender: TObject);     // screen ticker
var I1, I2:integer;                                // 45ms = approx 1/20th sec.
    S1, S2:str255;                                 // fallthrough after 30ms
      mark:int64;
        ch:char;
         S:string;
begin
  if length(ErrorText)<>0 then     // if there is an error message pending...
  begin
    S:=ErrorText;                          // save error message locally
    ErrorText:='';                         // clear message (to stop recursive calls)
    MessageDlg(S, ErrorType, [mbOk], 0);   // display local copy of error message
    exit
  end;

  mark:=GetTickCount64;

// *** until a maximum elapsed of 30ms, process characters to screen ***
  while (timesince(mark)<30) and (RB.head<>RB.tail) do
  begin
    ch:=RB.data[RB.tail];
    RB.tail:=(RB.tail+1) mod sizeof(RB.data);

    S1:=VT100engine(ch);                           // first process throught the VT100 engine
    for I1:=1 to length(S1) do
    begin
      S2:=GFXengine(S1[I1]);                       // then process through the GFX engine
      for I2:=1 to length(S2) do
      if S2[I2]=#05 then begin                     // ENQ -> ACK
                           if PB.idx=0 then
                           case CONNECTED of 2:WriteComm(#06);
                                             4:WriteSocket(#06)
                           end  { of case }
                         end
                    else emit(S2[I2])              // lastly print out the remainder
    end
  end
end;


// *** process paste operations, one character per loop through if in editor ***
procedure TForm1.Timer3Timer(Sender: TObject);     // paste ticker (variable)
const skip:byte=0;                                 // slow past + CR -> skip a few interrupts
        ch:char=#00;                               // last character pasted
var S:str255;
    I:integer;
begin
  if (PB.idx=0) and (Timer3.Interval<>300) then Timer3.Interval:=300;
                                                   // idles at 300ms
  if (PB.idx<>0) and (CONNECTED in [2,4]) then
  begin
    if PB.idx=1 then begin
                       Timer3.Interval:=15;        // ramp up to 15ms intervals
                       TS3:=GetTickCount64;        // force slow paste initially
                       TS5:=TS3;                   // timestamp start of paste operation
                       ch:=#00                     // no 'last' character loaded
                     end;

    if skip<>0 then begin
                      dec(skip);
                      exit
                    end;

    if timesince(TS3)>1000 then                    // *** fast paste ***
    begin                                          // ==================
      if timesince(TS1)>180 then CRwait:=0;        // 180ms timeout on seeing a handshake
                                                   // ( send <CR>  ->  receive <LF> )
//    if CRwait>0 then Form2.RichEdit1.Lines.Add('waiting at '+IntToStr(PB.idx));

      if CRwait<1 then
      begin
        S:='';
        I:=PB.idx;
        repeat
          ch:=PB.str[I];

          if ch=#13 then inc(CRwait);
          S:=S+ch;

          inc(I)
        until (I>PB.len) or (ch<#32) or            // grab a line up to and incl CR or LF
              (length(S)>=160) or                  // split lines > 160 characters long
        ((CommRate>120000) and (length(S)>=40));   // 40 char split at higher baud rates

        case CONNECTED of 2:if WriteComm(S) then PB.idx:=I;
                          4:if WriteSocket(S) then PB.idx:=I
        end  { of case }
      end
    end

    else                                           // *** slow paste ***
    begin                                          // ==================
      if not((ch=#13) and (timesince(TS1)<300)) then
      begin                                        // 300ms silence req'd after we've sent a <CR>
        ch:=PB.str[PB.idx];
        if ch=#13 then skip:=2;                    // introduce a 45ms delay after sending a <CR>
                                                   // to allow the editor to start responding.
//      if ch=#13 then inc(CRwait);                // note: editor will not respond to <CR>
                                                   // with anything that makes sense to us
        case CONNECTED of 2:if WriteComm(ch) then inc(PB.idx);
                          4:if WriteSocket(ch) then inc(PB.idx)
        end  { of case }
      end
    end;

    if (PB.idx>PB.len) then                        // have finished pasting
    begin
      PB.idx:=0;
      PB.len:=0;
      PB.str:='';
      TE5:=timesince(TS5)
    end
  end
end;


procedure TForm1.Timer4Timer(Sender: TObject);
var TempName:array [0..80] of char;
    TempFile:THandle;
         error:DWORD;
begin
  Timer4.Enabled:=false;

  if CONNECTED=2 then
  begin
    StrPCopy(TempName, copy('\\.\'+CommName,1,80));
    TempFile:=0;                       // needed to avoid compiler warning
    try
      TempFile:=CreateFile(TempName,
                           GENERIC_READ or GENERIC_WRITE,
                           0, Nil,
                           OPEN_EXISTING,
                           FILE_ATTRIBUTE_NORMAL, 0);
      error:=GetLastError
    except error:=DWORD(-1) end;

    try CloseHandle(TempFile) except end;

// 0:present and available  (ERROR_SUCCESS)
// 2:port is not present    (ERROR_FILE_NOT_FOUND)
// 5:present and in use     (ERROR_ACCESS_DENIED)

    if error=ERROR_FILE_NOT_FOUND then
    begin
      CONNECTED:=0;
      try CloseHandle(CommFile) except end;

      ErrorType:=mtError;
      ErrorText:='Serial I/O error: Unable to Locate Device'+#13+
                 #13+
                 'If you are using a USB to serial bridge,     '+#13+
                 'please check that the USB cable has not      '+#13+
                 'been unplugged.'
    end
  end

// ##################################remove once new method verified ###########
//if CONNECTED=2 then CONNECTED:=1     // temporarily disables serial comms and signal
end;                                   // other thread to check if still functioning


////////////////////////////////////////////////////////////////////////////////
// Keyboard and Mouse Events
// =========================
////////////////////////////////////////////////////////////////////////////////

// *** handle normal ascii keys ***
procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Memo1.Visible then exit;                  // ignore keys if text buffer visible
//windows.beep(880,50);

  lastK:=Key;
  if PB.idx=0 then case CONNECTED of 0:emit(Key);
                                     2:WriteComm(Key);
                                     4:WriteSocket(Key)
                   end  { of case }
end;


// *** handle special keys that need to be auto-repeating ***
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var S:string;
begin
  if Memo1.Visible then exit;                  // ignore keys if text buffer visible
//windows.beep(880,50);

  S:='';
  case Key of VK_LEFT:S:=#27+'[D';
                VK_UP:S:=#27+'[A';
             VK_RIGHT:S:=#27+'[C';
              VK_DOWN:S:=#27+'[B';
             VK_PRIOR:S:=#27+'[5~';
              VK_NEXT:S:=#27+'[6~';
              VK_HOME:S:=#27+'[1~';
               VK_END:S:=#27+'[4~';
            VK_INSERT:S:=#27+'[2~';
            VK_DELETE:S:=#127;                 // convert delete key to chr(127)
               VK_F10:Key:=0;                  // supress f10 popping up right-click menu
            VK_ESCAPE:if NetworkSearching then NetworkErrorFlag:=true
                                               // kludge to escape from loop while connecting
  end;  { of case }

  if (ssAlt in Shift) and (Key=VK_RETURN) then S:=#13#10;      // alt-enter -> cr+lf
  if (ssAlt in Shift) and (Key=ord('0')) then begin
                                                S:=#0;         // alt-0 -> nul
                                                lastK:=#0
                                              end;

//if (CONNECTED=2) and (PB.idx=0) and (length(S)>0) then WriteComm(S)
  if (PB.idx=0) and (length(S)>0) then
  case CONNECTED of 2:WriteComm(S);
                    4:WriteSocket(S)
  end  { of case }
end;


// *** handle non-repeating keys upon release ***
procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
var Reg:TRegistry;
      S:string;
begin
  if Memo1.Visible then                        // ignore keys if text buffer visible
  begin
    if (Key=13) or (Key=27) then               // except hide Memo1 on ESC or CR
    begin
      Form1.PopupMenu:=PopupMenu1;             // re-enable our popup menu

      Memo1.Lines.Clear;
      Memo1.Enabled:=false;                    // probably not needed
      Memo1.Visible:=false
//    Form1.SetFocus
    end;
    exit
  end;
//windows.beep(880,50);

// ssShift	The Shift key is held down.
// ssAlt	The Alt key is held down.
// ssCtrl	The Ctrl key is held down.

  S:='';                                       // default action: do nothing

// *** shifted and unshifted function keys ***
  if not (ssAlt in Shift) and not (ssCtrl in Shift) then       // disallow alt and ctrl
  if ssShift in Shift
  then case Key of VK_F3:S:=#27+'[25~';        // shifted function keys
                   VK_F4:S:=#27+'[26~';
                   VK_F5:S:=#27+'[28~';
                   VK_F6:S:=#27+'[29~';
                   VK_F7:S:=#27+'[31~';
                   VK_F8:S:=#27+'[32~';
                   VK_F9:S:=#27+'[33~';
                  VK_F10:S:=#27+'[34~'
       end  { of case }
  else case Key of VK_F1:S:=#27+'[11~';        // unshifted function keys
                   VK_F2:S:=#27+'[12~';
                   VK_F3:S:=#27+'[13~';
                   VK_F4:S:=#27+'[14~';
                   VK_F5:S:=#27+'[15~';
                   VK_F6:S:=#27+'[17~';
                   VK_F7:S:=#27+'[18~';
                   VK_F8:S:=#27+'[19~';
                   VK_F9:S:=#27+'[20~';
                  VK_F10:S:=#27+'[21~';
                  VK_F11:S:=#27+'[23~';
                  VK_F12:S:=#27+'[24~'
       end;  { of case }

// *** alt keys (letters and numbers), these are all 'special' commands ***
  if (ssAlt in Shift) and not (ssCtrl in Shift) and not (ssShift in Shift) then
  begin
    case Key of ord('B'):BreakCounter:=0;                      // try to reset micromite
                ord(' '):Item1Click(nil);                      // attempt to reconnect
                ord('P'):Item3Click(Item3A1);                  // paste from clipboard
                ord('C'):Item7Click(Item7A);
//                       begin
//                         GFXclear(0, 0, Gw, Gh);             // clear graphics layer
//                         Image2.Hide                         // hide graphics layer
//                       end;
                ord('D'):Item7Click(Item7B);
//                       clear(1, 1, COLS, ROWS);              // clear text layer
                ord('Z'):Item3Click(Item3B);
//                       begin                                 // cancel paste
//                         PB.idx:=0;
//                         PB.len:=0;
//                         PB.str:=''
//                       end;
                ord('A'):Item7Click(Item7C);
//                       RB.head:=RB.tail;                     // clear ring buffer
                ord('L'):Item2Click(nil);                      // stop/resume logging
//                       if LOGTOFILE then
//                       begin
//                         LOGTOFILE:=false;
//                         try CloseFile(LogFile) except end
//                       end;
                ord('R'):begin
                           if LOGTOFILE then                   // close log file if open
                           begin
                             try CloseFile(LogFile) except end;
                             LOGTOFILE:=false
                           end;

                           RB.head:=RB.tail;                   // empty ring buffer

                           PB.idx:=0;
                           PB.len:=0;
                           PB.str:='';                         // empty paste buffer

                           DimText:=false;                     // reset text attributes
                           InvText:=false;
                           TxtStyle:=[];
                           FGcolour:=FGdefault;                // reset text colours
                           BGcolour:=BGdefault;

                           GFX.Brush.Color:=clBlack;           // default brush: clBlack
                           GFX.Pen.Color:=clRed;               // default pen: clRed
                           GFX.Pen.Width:=1;                   // default line width: 1

                           Tmargin:=1;                         // reset scroll margins
                           Bmargin:=ROWS;

                           MouseMode:=0;                       // turn off mouse reporting
                           CursorVis:=true;                    // unhide cursor
                           VTinsMode:=false;                   // select replacement mode

                           clear(1, 1, COLS, ROWS);            // clear text layer
                           GFXclear(0, 0, Gw, Gh);             // clear graphics layer
                           Image2.Hide;                        // hide graphics layer
                           gotoxy(1,1)                         // home cursor
                         end;
                ord('U'):CursorVis:=not CursorVis;             // toggle cursor visible/hidden

                ord('M'):PopupMenu1.Popup(Mouse.CursorPos.x, Mouse.CursorPos.Y);

                ord('1'):try EscapeCommFunction(CommFile, SETDTR) except end;  // set DTR
                ord('2'):try EscapeCommFunction(CommFile, CLRDTR) except end;  // clear DTR
                ord('3'):try EscapeCommFunction(CommFile, SETRTS) except end;  // set RTS
                ord('4'):try EscapeCommFunction(CommFile, CLRRTS) except end   // clesr RTS
    end  { of case }                               // don't try using alt-0 in here, as it is
  end;                                             // set to generate nul in TForm1.FormKeyDown

// ######################################################################
// the following key actions are for testing purposes only. there is NO
// guarantee that any given function will remain the same, or be present,
// between different releases of GFXterm.
// ######################################################################

  if (ssCtrl in Shift) and not (ssAlt in Shift) and not (ssShift in Shift) then
  begin
    case Key of ord('1'):begin                                 // ctrl-1
                           Panel1.DoubleBuffered:=false;       // turn off double buffering
                           ShowMessage('Double Buffering is OFF')
                         end;
                ord('2'):begin                                 // ctrl-2
                           Panel1.DoubleBuffered:=true;        // turn on double buffering
                           ShowMessage('Double Buffering is ON')
                         end;
                ord('3'):begin                                 // ctrl-3
                           PAL[0]:=$00FFFFFF-PAL[0];           // swap black and white
                           PAL[15]:=$00FFFFFF-PAL[15];
                           Shape1.Pen.Color:=PAL[0]
                         end;
(*
                         begin
                           for I:=0 to 15 do PAL[I]:=$00FFFFFF-PAL[I];
                           Shape1.Pen.Color:=PAL[0]
                         end;
*)
                ord('4'):begin                                 // ctrl-4
                           if CONNECTED=4 then CONNECTED:=0;
                           try ClientSocket1.Close except end; // force network disconnect
                           ShowMessage('Client Socket has been CLOSED')
                         end;
                ord('6'):begin                                 // ctrl-6
                           S:=pad(12,Cursor.Font.Name)+#13+#13;
                           S:=S+pad(12,'FontIndex = '+IntToStr(FontIndex))+#13;
                           if Cursor.AutoSize then S:=S+pad(12,'AutoSize = ON')+#13
                                              else S:=S+pad(12,'(AutoSize = OFF')+#13;
                           S:=S+pad(12,'('+IntToStr(Cursor.Width)+' x '+
                                           IntToStr(Cursor.Height)+')')+#13;
                           if CONNECTED<>0 then
                               S:=S+#13+'connected for '+DHMStime(timesince(TS4))+#13+
                                         'last RxD was '+DHMStime(timesince(TS1))+' ago'+#13+
                                         'last TxD was '+DHMStime(timesince(TS2))+' ago'+#13+
                                         #13+
                                         'last paste took '+IntToStr(TE5 div 1000)+'.'
                                                           +IntToStr((TE5 mod 1000) div 100)
                                                           +' seconds'+#13;
                           ShowMessage(S);
                           S:=''
                         end;
                ord('7'):begin                                 // ctrl-7
                           LOGEXTEND:=not LOGEXTEND;           // toggle extended logging flag
                           if LOGEXTEND then ShowMessage('Extended Logging Format is ENABLED')
                                        else ShowMessage('Extended Logging Format is DISABLED')
                         end;
                ord('9'):begin                                 // ctrl-9
                           Reg:=TRegistry.Create;
                           with Reg do                         // remove registry key
                           begin
                             RootKey:=HKEY_CURRENT_USER;
                             try DeleteKey(SoftwareKey) except end;
                           end;
                           Reg.Free;
                           ShowMessage('Registry Data has been CLEARED')
                         end
    end  { of case }
  end;

  if (PB.idx=0) and (length(S)>0) then
  case CONNECTED of 2:WriteComm(S);
                    4:WriteSocket(S)
  end  { of case }
end;


procedure TForm1.Panel1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var flags:byte;
        S:string;
begin
  if (CONNECTED in [2,4]) and (MouseMode>0) and (Button=mbLeft) and (PB.idx=0) then
  begin
    if sender=Cursor then begin
                            MouseX:=min(Xpos, COLS);           // fix: can be =81 if at end of line
                            MouseY:=Ypos
                          end
                     else begin
                            MouseX:=trunc(((X { -Image1.Left } )/Cursor.Width)+1);
                            MouseY:=trunc(((Y { -Image1.Top  } )/Cursor.Height)+1)
                          end;

//  ShowMessage(IntToStr(MouseX)+','+IntToStr(MouseY))
    if (MouseX>=1) and (MouseX<=COLS) and (MouseY>=1) and (MouseY<=ROWS) then
    begin
      flags:=0;
//    if GetAsyncKeyState(VK_SHIFT)<0   then inc(flags, 4);
//    if GetAsyncKeyState(VK_MENU)<0    then inc(flags, 8);
//    if GetAsyncKeyState(VK_CONTROL)<0 then inc(flags,16);
      if ssShift in Shift then inc(flags, 4);
      if ssAlt in Shift then inc(flags, 8);
      if ssCtrl in Shift then inc(flags, 16);

      case MouseMode of $0001:S:=#27+'[M '+chr(32+MouseX)+chr(32+MouseY);                  // X10
                        $0101:S:=#27+'[<0;'+IntToStr(MouseX)+';'+IntToStr(MouseY)+'M';     // X10/SGR
                        $1001:S:=#27+'[32;'+IntToStr(MouseX)+';'+IntToStr(MouseY)+'M';     // X10/URXVT

                        $0010:S:=#27+'[M'+chr(32+flags)+chr(32+MouseX)+chr(32+MouseY);                     // VT200
                        $0110:S:=#27+'[<'+IntToStr(flags)+';'+IntToStr(MouseX)+';'+IntToStr(MouseY)+'M';   // VT200/SGR
                        $1010:S:=#27+'['+IntToStr(32+flags)+';'+IntToStr(MouseX)+';'+IntToStr(MouseY)+'M'  // VT200/URXVT
                     else S:=''
      end ; { of case }

      if (PB.idx=0) and (length(S)>0) then
      case CONNECTED of 2:WriteComm(S);
                        4:WriteSocket(S)
      end  { of case }
    end
  end
end;


procedure TForm1.Panel1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var flags:byte;
        S:string;
begin
  if (CONNECTED in [2,4]) and (MouseMode>0) and (Button=mbLeft) and (PB.idx=0) then
  begin
    if sender=Cursor then begin
                            MouseX:=min(Xpos, COLS);           // fix: can be =81 if at end of line
                            MouseY:=Ypos
                          end
                     else begin
                            MouseX:=trunc(((X { -Image1.Left } )/Cursor.Width)+1);
                            MouseY:=trunc(((Y { -Image1.Top  } )/Cursor.Height)+1)
                          end;

//  ShowMessage(IntToStr(MouseX)+','+IntToStr(MouseY))
    if (MouseX>=1) and (MouseX<=COLS) and (MouseY>=1) and (MouseY<=ROWS) then
    begin
      flags:=0;
//    if GetAsyncKeyState(VK_SHIFT)<0   then inc(flags, 4);
//    if GetAsyncKeyState(VK_MENU)<0    then inc(flags, 8);
//    if GetAsyncKeyState(VK_CONTROL)<0 then inc(flags,16);
      if ssShift in Shift then inc(flags, 4);
      if ssAlt in Shift then inc(flags, 8);
      if ssCtrl in Shift then inc(flags, 16);

      case MouseMode of $0010:S:=#27+'[M'+chr(32+3+flags)+chr(32+MouseX)+chr(32+MouseY);                       // VT200
                        $0110:S:=#27+'[<'+IntToStr(flags)+';'+IntToStr(MouseX)+';'+IntToStr(MouseY)+'m';       // VT200/SGR
                        $1010:S:=#27+'['+IntToStr(32+3+flags)+';'+IntToStr(MouseX)+';'+IntToStr(MouseY)+'M'    // VT200/URXVT
                     else S:=''
      end ; { of case }

      if (PB.idx=0) and (length(S)>0) then
      case CONNECTED of 2:WriteComm(S);
                        4:WriteSocket(S)
      end  { of case }
    end
  end
end;


procedure TForm1.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if Sender=Cursor then begin
                          MouseX:=min(Xpos, COLS);      // fix: can be =81 if at end of line
                          MouseY:=Ypos
                        end
                   else begin
                          MouseX:=trunc(((X { -Image1.Left } )/Cursor.Width)+1);
                          MouseY:=trunc(((Y { -Image1.Top  } )/Cursor.Height)+1)
                        end
end;


procedure TForm1.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
var S:string;
begin
  if Memo1.Visible then exit;                  // ignore mouse wheel if text buffer visible
  if Form2.RichEdit1.Focused then exit;        // ignore mouse wheel if looking at command window

  if WheelDelta>0 then S:=#27+'[A' else
  if WheelDelta<0 then S:=#27+'[B' else S:='';

  if (PB.idx=0) and (length(S)>0) then
  case CONNECTED of 2:WriteComm(S);
                    4:WriteSocket(S)
  end; { of case }
//windows.beep(880,50);
  Handled:=true
end;


////////////////////////////////////////////////////////////////////////////////
// startup (FormCreate) and shutdown (FormClose) code
// ==================================================
////////////////////////////////////////////////////////////////////////////////

procedure TForm1.FormCreate(Sender: TObject);
var I,n1,n2,n3:integer;
           Reg:TRegistry;
            SL:TstringList;
            RS:TResourceStream;
            DW:DWORD;
             S:string;
             T:textfile;
begin
  Unit1.Cursor:=Form1.Cursor;

//Application.HintHidePause:=5000;
  Form1.Caption:=BuildName;            // updated by Timer1
  Application.Title:='GFXterm';        // updated by Timer1

  for I:=0 to 15 do PAL[I]:=CVT[I];    // load default palette values

  S:=ChangeFileExt(ExpandFileName(paramstr(0)),'.PAL');
  if FileExists(S) then
  try
    assignfile(T, S);
    Reset(T);
//  ReWrite(T);

    for I:=0 to 15 do
    begin
//    Writeln(T,'0x'+Format('%.6x',[PAL[I]]));
      Readln(T,S);
      if S='' then Readln(T,S);
      if pos(' ', S)<>0 then S:=copy(S, 1, pos(' ', S)-1);
      PAL[I]:=StrToInt(S)
    end;
    CloseFile(T)
  except
    for I:=0 to 15 do PAL[I]:=CVT[I];
    try CloseFile(T) except end;
    ErrorType:=mtWarning;
    ErrorText:='    Error reading .PAL file,   '+#13+
               '    using default VT palette    '
  end;
(*
  WhiteLevel:=255;
  BlackLevel:=96;

  for I:=0 to 15 do if I in [0, 7, 8, 15] then
  begin
    n1:=(CVT[I] and $000000FF);
    n2:=(CVT[I] and $0000FF00) shr 8;
    n3:=(CVT[I] and $00FF0000) shr 16;

    n1:=BlackLevel + (n1 * (WhiteLevel-BlackLevel) div $FF);
    n2:=BlackLevel + (n2 * (WhiteLevel-BlackLevel) div $FF);
    n3:=BlackLevel + (n3 * (WhiteLevel-BlackLevel) div $FF);

    if n1>$FF then n1:=$FF;
    if n2>$FF then n2:=$FF;
    if n3>$FF then n3:=$FF;

    PAL[I]:=n1 + (n2 shl 8) + (n3 shl 16)
  end;
*)

  if paramcount<>0 then S:=uppercase(paramstr(1));
  if (paramcount=1) and ((S='/E') or (S='-E')) then LOGEXTEND:=true;
  if paramcount=2 then
  begin
    if (S='/S') or (S='-S') then CommandSwitch:=1 else
    if (S='/N') or (S='-N') then CommandSwitch:=2 else
                                 CommandSwitch:=0
  end;

  Form1.AutoSize:=true;
  Panel1.AutoSize:=true;

//Form1.AutoScroll:=false;             // set in form view
//Form1.KeyPreview:=true;              // set in form view
//Form1.DoubleBuffered:=true;
  Panel1.DoubleBuffered:=true;         // only double-buffer Panel1 instead of whole form

// the following method to loading fonts into RAM was taken from:
// http://forum.lazarus.freepascal.org/index.php?topic=26003.0
// << Reply #2 on: October 02, 2014, 10:31:27 am >>
  for I:=1 to 7 do
  begin
    RS:=TResourceStream.Create(hInstance, 'font'+IntToStr(I), 'RT_FONT');
    try
      FontHandle[I]:=AddFontMemResourceEx(RS.Memory, RS.Size, nil, @DW)
    except end;
    RS.Free
  end;

  Item4A.Caption:=FontList[1].Desc;
  Item4B.Caption:=FontList[2].Desc;
  Item4C.Caption:=FontList[3].Desc;
  Item4D.Caption:=FontList[4].Desc;
  Item4E.Caption:=FontList[5].Desc;
  Item4F.Caption:=FontList[6].Desc;
  Item4G.Caption:=FontList[7].Desc;
  Item4H.Caption:=FontList[8].Desc;
  Item4I.Caption:=FontList[9].Desc;
  Item4J.Caption:=FontList[10].Desc;

////////////////////////////////////////////////////////////////////////////////
// disable selection of Terminal 9pt if a substitute is offered
////////////////////////////////////////////////////////////////////////////////
  FontIndex:=8;                                // Terminal 9pt
  Cursor.Font.Name:=FontList[8].Name;
  Cursor.Font.Size:=FontList[8].Size;
  if Cursor.Width<8 then                       // we are missing Terminal 9pt
  begin
    Item4H.Enabled:=false;
    FontIndex:=1                               // BigBlue Terminal 8 x 12
  end;
  Cursor.Font.Name:=FontList[FontIndex].Name;
  Cursor.Font.Size:=FontList[FontIndex].Size;
////////////////////////////////////////////////////////////////////////////////

  Reg:=TRegistry.Create;
  with Reg do
  begin
    RootKey:=HKEY_CURRENT_USER;

    try
      if OpenKey(SoftwareKey, false) then
      begin
        SL:=TStringList.Create;
        try                            // try to read font size from registry
          I:=ReadInteger('FontIndex');
          if I in [1..10] then begin
                                 if (I=8) and not Item4H.Visible then I:=1;
                                 Cursor.Font.Name:=FontList[I].Name;
                                 Cursor.Font.Size:=FontList[I].Size;
                                 FontIndex:=I
                               end else
          begin                        // manual font override (for Linux)
            SL.CommaText:=ReadString('FontInfo');
            if SL.Count=4 then         // exactly 4 parameters required
            begin
//            windows.beep(880,250);
              S:=SL[0];
              n1:=StrToInt(SL[1]);
              n2:=StrToInt(SL[2]);
              n3:=StrToInt(SL[3]);
              Cursor.Font.Name:=S;
              Cursor.Font.Charset:=n1;
              Cursor.Font.Size:=n2;
              Cursor.AutoSize:=false;
              Cursor.Width:=n3;
              FontIndex:=0
            end
          end
        except end;
        SL.Free;

        try                            // try to read foreground colour from registry
          I:=ReadInteger('DefaultFG');
          if I in [1..7] then begin FGdefault:=I; FGcolour:=I end
        except end;
(*
        try                            // try to read background colour from registry
          I:=ReadInteger('DefaultBG');
          if I in [0..6] then begin BGdefault:=I; BGcolour:=I end
        except end;
*)
        try                            // try to read dim text option from registry
          I:=ReadInteger('DimOption');
          if I in [0..2] then DimOpt:=I
        except end
      end
    except end;
    try CloseKey except end
  end;
  Reg.Free;

////////////////////////////////////////////////////////////////////////////////
// start of code to rearrange and resize components for display
////////////////////////////////////////////////////////////////////////////////
  Shape1.Left:=0;
  Shape1.Top:=Label1.Height+2;
  Shape1.Width:=Cursor.Width*COLS        +4;   // +4 -> 2 pixel boarder all around
  Shape1.Height:=Cursor.Height*ROWS      +4;
  Shape1.Pen.Color:=PAL[0];

  Panel1.Left:=0                         +2;   // +2 -> centre in boarder (Shape1)
  Panel1.Top:=Label1.Height+2            +2;

  for I:=0 to ComponentCount-1 do if Components[I] is TLabel then
    TLabel(Components[I]).Left:=TLabel(Components[I]).Left + 2;

  // create text area
  Image1.Left:=0;                                      // horizontal position of screen grid
  Image1.Top:=0;                                       // vertical position of screen grid
  Image1.Picture.Bitmap:=TBitmap.Create;               // create a bitmap object for text
  Image1.Picture.Bitmap.Width:=Cursor.Width*COLS;      // set width
  Image1.Picture.Bitmap.Height:=Cursor.Height*ROWS;    // set height
  Image1.Picture.Bitmap.Canvas.TextFlags:=ETO_OPAQUE;  // opaque writing of text, improves speed
  Image1.Picture.Bitmap.Canvas.Font:=Cursor.Font;      // copy font details from cursor object
  Image1.Picture.Bitmap.Canvas.Font.Style:=[];         // no underline, etc.
  Image1.Picture.Bitmap.Canvas.Font.Color:=clWhite;    // WHITE text by default
  Image1.Picture.Bitmap.Canvas.Brush.Color:=clBlack;   // default brush: clBlack (for clearing screen)

// create graphics area
  Image2.Left:=Image1.Left;                            // graphics plane overlays text plane
  Image2.Top:=Image1.Top;
//Image2.Transparent:=true;                            // allow transparence (set in form view)
  Image2.Picture.Bitmap:=TBitmap.Create;               // create a bitmap object for graphics
  Image2.Picture.Bitmap.Width:=Cursor.Width*COLS;      // set width
  Image2.Picture.Bitmap.Height:=Cursor.Height*ROWS;    // set height
  Image2.Picture.Bitmap.Canvas.Brush.Color:=clBlack;   // default brush: clBlack (for clearing screen)
  Image2.Picture.Bitmap.Canvas.Pen.Color:=clRed;       // default pen: clRed (for drawing lines)
  Image2.Picture.Bitmap.Canvas.Pen.Width:=1;

  Image2.Picture.Bitmap.TransparentColor:=clBlack;     // transparent colour is black
  Image2.Picture.Bitmap.TransparentMode:=tmFixed;      // use above setting for TC

  Image3.Autosize:=true;
  Image3.Left:=Image1.Left+Image1.Width-Image3.Width;
  Image3.Top:=Image1.Top;
  Image3.Hide;

// configure cursor
  Cursor.Top:=Image1.Top;                              // initial cursor row
  Cursor.Left:=Image1.Left;                            // initial cursor column
  Cursor.Font.Color:=clRed;                            // cursor colour (FG)
  Cursor.Color:=clRed;                                 // cursor colour (BG)

// configure text copy object
  Memo1.Left:=Image1.Left;
  Memo1.Top:=Image1.Top;
(*                                                     // the following are handled
  Memo1.Width:=Cursor.Width*COLS;                      // within right-click menu's
  Memo1.Height:=Cursor.Height*ROWS;                    /  Item8

  Memo1.Font:=Cursor.Font;
  Memo1.Font.Style:=[];
  Memo1.Font.Color:=clBlack;           // black text on
  Memo1.Color:=clSilver;               // a silver background
*)
  Memo1.Hint:='Select the text you want to copy using the mouse,'+#13+
              'then press control-C to copy it to the clipboard.'+#13+
              'When finished, press ENTER to exit this view.';

  Label5.Color:=clLime;                // green 'running' annunciator by default
  Label6.Color:=clYellow;              // yellow 'logging' annunciator by default
  Label7.Color:=clAqua;                // light blue paste annunciator by default

  OpenDialog1.InitialDir:=ExtractFilePath(ExpandFileName(paramstr(0)));
  SaveDialog1.InitialDir:=ExtractFilePath(ExpandFileName(paramstr(0)));

// align graphics and text layers along the Z-axis
  Memo1.Enabled:=false;                // probably not needed
  Memo1.Visible:=false;
  Memo1.SendToBack;

  Image1.Enabled:=false;               // ignore mouse and keyboard events
  Image2.Enabled:=false;               // ignore mouse and keyboard events
  Image3.Enabled:=false;               // ignore mouse and keyboard events

  Image1.BringToFront;                 // text layer ends in background
  Image2.BringToFront;                 // graphics layer overlays text
  Image3.BringToFront;

  Cursor.BringToFront;                 // cursor always on top of text and graphics

// create shortcuts
  SCR:=Image1.Picture.Bitmap.Canvas;   // shorthand for canvas object (text screen)
  GFX:=Image2.Picture.Bitmap.Canvas;   // shorthand for canvas object (graphics screen)

  clear(1, 1, COLS, ROWS);             // clear text layer
  GFXclear(0, 0, Gw, Gh);              // clear graphics layer
  gotoxy(1,1);                         // home cursor
  Image2.Hide;                         // graphics layer is turned off initially
  TS1:=GetTickCount64;
  TS2:=TS1;
  TS3:=TS2;
  TS4:=TS3
{
  TUSBcheckThread.Create(false)
}
end;


procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var I:integer;
begin
  case CONNECTED of 1,2:try
                          CONNECTED:=0;
                          CloseHandle(CommFile)
                        except end;
                      4:try
                          CONNECTED:=0;
                          ClientSocket1.Close
                        except end
  end;  { of case }

  if LOGTOFILE then try
                      LOGTOFILE:=false;
                      CloseFile(Logfile)
                    except end;

  sleep(200);
  for I:=1 to 7 do RemoveFontMemResourceEx(FontHandle[I])
end;


//------------------------------------------------------------------------------
// start: unused launch application code
//------------------------------------------------------------------------------
(*
procedure CaptureConsoleOutput(const ACommand, AParameters: string;
                               var ExitCode: integer);
var saSecurity:TSecurityAttributes;
    suiStartup:TStartupInfo;
     piProcess:TProcessInformation;
    ReadBuffer:array [0..127] of char;
     BytesRead,
    BytesAvail:DWORD;
       Running:DWORD;
           I,J:integer;
             S:string;
            ch:char;
            LB:LongBool;
 begin
   ExitCode:=-($DEAD);         // default exit code if unable to complete

   FillChar(saSecurity, SizeOf(TSecurityAttributes), #0);
   saSecurity.nLength:=SizeOf(TSecurityAttributes);
   saSecurity.bInheritHandle:=true;            // seems to be essential for pipes
   saSecurity.lpSecurityDescriptor:=nil;

   if CreatePipe(hRead_local, hWrite_remote, @saSecurity, 0) then
   if CreatePipe(hRead_remote, hWrite_local, @saSecurity, 0) then     { try 1 byte write }
   begin
     FillChar(suiStartup, SizeOf(TStartupInfo), #0);
     suiStartup.cb:=SizeOf(TStartupInfo);
     suiStartup.hStdInput:=hRead_remote;
     suiStartup.hStdOutput:=hWrite_remote;
     suiStartup.hStdError:=hWrite_remote;
     suiStartup.dwFlags:=STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
     suiStartup.wShowWindow:=SW_HIDE;
{
   dwXCountChars, dwYCountChars
dwFlags specifies STARTF_USECOUNTCHARS.
For console processes,
if a new console window is created,
dwXCountChars specifies the screen buffer
width in character columns, and dwYCountChars
specifies the screen buffer height in character rows.
These values are ignored in GUI processes.  }

     saSecurity.bInheritHandle:=false;         // standard handles are still inherited

     if CreateProcess(nil, PChar(ACommand + ' ' + AParameters),
                      @saSecurity, @saSecurity,
//                    nil, nil,
                      True, NORMAL_PRIORITY_CLASS,
                      nil, nil, suiStartup, piProcess) then
     begin
       CONNECTED:=true;
// ***************************************
//     try CloseHandle(hWrite) except ShowMessage('unable to close hWrite') end;
// ***************************************

       repeat
         Running:=WaitForSingleObject(piProcess.hProcess, 20);
//       Application.ProcessMessages();
         repeat
           Application.ProcessMessages();
           try
             if PeekNamedPipe(hRead_local, nil, 0, nil, @BytesAvail, nil) and (BytesAvail>0)
                then LB:=ReadFile(hRead_local, ReadBuffer[0],
                                  min(sizeof(ReadBuffer), BytesAvail), BytesRead, nil)
                else LB:=false
           except
             LB:=false
           end;       // may exit with ERROR_BROKEN_PIPE after child process closes

           if not LB then BytesRead:=0 else
           begin
             for I:=1 to BytesRead do
             begin
               ch:=ReadBuffer[I-1];
               S:=VT100engine(ch);
               for J:=1 to length(S) do emit(S[J])
             end
           end;
         until (BytesRead<sizeof(ReadBuffer)) or KILL
       until (Running<>WAIT_TIMEOUT) or KILL;

       CONNECTED:=false;

       GetExitCodeProcess(piProcess.hProcess, DWORD(ExitCode));  // returns STILL_ACTIVE if still running
       if KILL then TerminateProcess(piProcess.hProcess, 0);

       try CloseHandle(piProcess.hProcess) except end;
       try CloseHandle(piProcess.hThread) except end
     end;

     try CloseHandle(hRead_local) except end;
     try CloseHandle(hWrite_local) except end;
     try CloseHandle(hRead_remote) except end;
     try CloseHandle(hWrite_remote) except end

   end;
   DEAD:=true
end;


procedure RUNprogram;
var I:integer;
    S:string;
begin
  if not CONNECTED then
  if inputquery('RUN', 'enter program to launch', S) then
  begin
    DEAD:=false;
    KILL:=false;
    emit(#13);
    emit(#10);
    CaptureConsoleOutput(S,'', I);
    emit(#13);
    emit(#10)
  end
end;


procedure STOPprogram;
begin
  KILL:=true
end;
*)
//------------------------------------------------------------------------------
// end: unused launch application code
//------------------------------------------------------------------------------


////////////////////////////////////////////////////////////////////////////////
// popup menu item handlers
// ========================
////////////////////////////////////////////////////////////////////////////////

// *** popup menu - configure menu before making visible ***********************
procedure TForm1.PopupMenu1Popup(Sender: TObject);
begin
  Item1A.Visible:=(CONNECTED=0);
  Item1B.Visible:=(CONNECTED<>0);
  Item1B.Enabled:=(CONNECTED<>1);
  Item2A.Visible:=not LOGTOFILE;
  Item2B.Visible:=LOGTOFILE;
  Item3A.Visible:=(PB.idx=0);
  Item3B.Visible:=(PB.idx<>0);

  case FontIndex of 1:Item4A.Checked:=true;
                    2:Item4B.Checked:=true;
                    3:Item4C.Checked:=true;
                    4:Item4D.Checked:=true;
                    5:Item4E.Checked:=true;
                    6:Item4F.Checked:=true;
                    7:Item4G.Checked:=true;
                    8:Item4H.Checked:=true;
                    9:Item4I.Checked:=true;
                   10:Item4J.Checked:=true
                 else Item4K.Checked:=true

  end;  { of case }

  case FGdefault of 1:Item5A.Checked:=true;
                    2:Item5B.Checked:=true;
                    3:Item5C.Checked:=true;
                    4:Item5D.Checked:=true;
                    5:Item5E.Checked:=true;
                    6:Item5F.Checked:=true;
                    7:Item5G.Checked:=true
  end;  { of case }
  case DimOpt of 0:Item6A.Checked:=true;
                 1:Item6B.Checked:=true;
                 2:Item6C.Checked:=true
  end  { of case }
end;


// popup menu item - CONNECT / DISCONNECT
procedure TForm1.Item1Click(Sender: TObject);
var name,config:string;
      selection:integer;
          shift:boolean;
          I,J,N:integer;
        S,S1,S2:string;
            Reg:TRegistry;
begin
  if NetworkSearching or (CONNECTED=1) then exit;
  shift:=(GetAsyncKeyState(VK_SHIFT)<0) and (Sender<>nil);

  S1:='';
  S2:='';
  selection:=0;

  Reg:=TRegistry.Create;       // try to read S from registry
  with Reg do
  begin
    RootKey:=HKEY_CURRENT_USER;
    try
      if OpenKey(SoftwareKey, false) then
      begin
        try S1:=ReadString('CommPort') except end;
        try S2:=ReadString('HostInfo') except end;
        if Sender=nil then try selection:=ReadInteger('LastUsed') except end;
      end
    except end;
    try CloseKey; except end
  end;
  Reg.Free;

  if (selection=1) and not VerifyCommPort(S1) then selection:=0;

  if CommandSwitch<>0 then
  begin
    I:=CommandSwitch;
    CommandSwitch:=0;
//  ShowMessage('command switch set to '+inttostr(I));
    case I of 1:if not VerifyCommPort(paramstr(2)) then exit else
                begin
                  selection:=1;
                  S1:=paramstr(2);                         //////////////////////////////
                  if pos(':',S1)=0 then S1:=S1+':38400'    // insert default baud rate //
//                ; ShowMessage('serial: <'+S1+'>')        //////////////////////////////
                end;
              2:begin
                  selection:=2;
                  S2:=paramstr(2)
//                ; ShowMessage('network: <'+S2+'>')
                end
    end   { of case }
  end;

  case CONNECTED of 4:try                              // connected to network
                        CONNECTED:=0;
                        ClientSocket1.Close
                      except end;
                    2:try                              // connected to comm port
                        CONNECTED:=0;
                        CloseHandle(CommFile)
                      except end
                 else repeat
                        if shift then begin
                                        if InputQuery('CONNECT', 'enter <port>:<baud>', S1)
                                            then N:=1
                                            else N:=0;
                                        S:=S1
                                      end
                                 else begin
                                        if selection=0 then N:=SelectPortOrHost(S1, S2)
                                                       else N:=selection;
                                        selection:=0;

                                        case N of 1:S:=S1;
                                                  2:S:=S2
                                               else S:=''
                                        end  { of case }
                                      end;

                        if N<>0 then
                        begin
                          I:=pos(':',S);

                          if I>1 then
                          begin
                            name:=copy(S,1,I-1);

                            if N=1 then begin
                                          config:='baud='+copy(S,I+1,length(S)-I)+
                                                  ' parity=n data=8 stop=1';
                                          SetupCommPort(name, config)
                                        end
                                   else try
                                          J:=StrToInt(copy(S,I+1,length(S)-I));
                                          ClientSocket1.Host:=name;
                                          ClientSocket1.Port:=J;
                                          NetworkErrorFlag:=false;
                                          NetworkSearching:=true;
                                          ClientSocket1.Open;

                                          TS1:=GetTickCount64;
                                          TS2:=TS1;
                                          TS3:=TS2;
                                          TS4:=TS3;

                                          repeat
                                            Application.ProcessMessages;
                                            case Panel1.Cursor of crSizeNESW:Panel1.Cursor:=crSizeWE;
                                                                    crSizeWE:Panel1.Cursor:=crSizeNWSE;
                                                                  crSizeNWSE:Panel1.Cursor:=crSizeNS
                                                               else          Panel1.Cursor:=crSizeNESW
                                            end;  { of case }
                                            sleep(100)
                                          until (timesince(TS1)>30000) or      // 30 second timeout
                                                ClientSocket1.Active or        // connection active
                                                NetworkErrorFlag;              // error flag set
                                          Panel1.Cursor:=crDefault;

//                                        if not ClientSocket1.Active then N:=0 else
                                          if ClientSocket1.Active then
                                          begin
                                            TS1:=GetTickCount64;
                                            TS2:=TS1;
                                            TS3:=TS2;
                                            TS4:=TS3;
                                            CONNECTED:=4
                                          end;
                                          NetworkErrorFlag:=false;
                                          NetworkSearching:=false
//                                        ShowMessage('host name detected')
                                        except end
                          end
                        end;

                        if CONNECTED in [2,4] then          // save S into registry
                        begin
                          Reg:=TRegistry.Create;
                          with Reg do
                          begin
                            RootKey:=HKEY_CURRENT_USER;
                            try
                              if OpenKey(SoftwareKey, true) then
                              case CONNECTED of 2:begin
                                                    WriteString('CommPort', S);
                                                    WriteInteger('LastUsed', 1)
                                                  end;
                                                4:begin
                                                    WriteString('HostInfo', S);
                                                    WriteInteger('LastUsed', 2)
                                                  end
                              end  { of case }
                            except end;
                            try CloseKey except end
                          end;
                          Reg.Free
                        end
                      until (CONNECTED in [2,4]) or (N=0)
  end  { of case }
end;


// popup menu item - LOG to file / STOP logging
procedure TForm1.Item2Click(Sender: TObject);
var appendflag:boolean;
begin
  appendflag:=(Sender=nil) and FileExists(SaveDialog1.Filename);

  if LOGTOFILE then begin
                      LOGTOFILE:=false;
                      try CloseFile(LogFile) except end
                    end
               else if appendflag or SaveDialog1.Execute then
                    try
                      AssignFile(LogFile, SaveDialog1.Filename);
                      if appendflag then Append(LogFile)
                                    else ReWrite(LogFile);
                      LOGTOFILE:=true
                    except
                      LOGTOFILE:=false;
                      try CloseFile(Logfile) except end;
                      ErrorType:=mtWarning;
                      ErrorText:='Could not open file:'+#13+
                                 ExtractFileName(SaveDialog1.FileName)+#13
                    end
end;


// popup menu item - paste from clipboard / paste from text file / CANCEL paste
procedure TForm1.Item3Click(Sender: TObject);
var SL:TStringList;
     S:string;
     I:integer;
begin
// setup for paste from clipboard
  if Sender=Item3A1 then begin
                           if PB.idx<>0 then exit;
                           if ClipBoard.HasFormat(CF_TEXT) then
                           try
                             S:=ClipBoard.AsText;
                           except
                             S:=''
//                           ShowMessage('ClipBoard exception')
                           end
                         end;

// setup for paste from text file
  if Sender=Item3A2 then begin
                           if PB.idx<>0 then exit;
                           if OpenDialog1.Execute then
                           begin
                             SL:=TStringlist.Create;
                             try
                               SL.LoadFromFile(OpenDialog1.Filename);
                               S:=SL.Text
                             except
                               S:=''
//                             ShowMessage('LoadFromFile exception')
                             end;
                             SL.Free
                           end
                         end;

// common code for both types of paste (from clipboard and from text file)
  if (Sender=Item3A1) or (Sender=Item3A2) then
  begin
    for I:=1 to length(S) do             // clear bit-7 of all characters being pasted
        S[I]:=char(byte(S[I]) and $7F);

    I:=pos(#13#10, S);
    while I<>0 do
    begin                                // translate all CR-LF pairs into single CR
      delete(S, I+1, 1);
      I:=pos(#13#10, S)
    end;

    for I:=1 to length(S) do             // translate any remaining LFs into CRs
        if S[I]=#10 then S[I]:=#13;

    for I:=length(S) downto 1 do         // remove any other control characters (except crtl-Z)
        if S[I] in [#0..#12,#14..#25,#27..#31  {,#127..#255}  ] then delete(S, I, 1);

    I:=pos(#32#13, S);
    while I<>0 do
    begin                                // remove all trailing spaces at ends of lines
      delete(S, I, 1);
      I:=pos(#32#13, S)
    end;

    while (length(S)<>0) and (S[length(S)]=#32) do delete(S, length(S), 1);
                                         // remove final trailing spaces at end of S
(*
    for I:=1 to length(S) do             // translate all CRs into LFs as
        if S[I]=#13 then S[I]:=#10;      // test for unix formatted files
*)
(*
    for I:=1 to length(S) do             // set bit-7 of all characters being pasted
        S[I]:=char(byte(S[I]) or $80);   // test for ignoring bit-7 set
*)

    if length(S)<>0 then
    begin
      PB.str:=S;                         // load data into string ready to be streamed
      PB.len:=length(S);                 // out of the comm port by a timer interrupt
      PB.idx:=1
    end
  end;

// code for CANCEL paste
  if Sender=Item3B then begin            // cancel paste
                          PB.idx:=0;
                          PB.len:=0;
                          PB.str:=''
                        end
end;


// popup menu item - font size 9pt / 12pt / 14pt
procedure TForm1.Item4Click(Sender: TObject);
var Reg:TRegistry;
    I,J:integer;
    OEM:boolean;
      S:string;
begin
  if Sender is TMenuItem then
  begin
    I:=TMenuItem(Sender).Tag;
    if I in [1..10] then begin
                           Cursor.Font.Name:=FontList[I].Name;
                           Cursor.Font.Charset:=OEM_CHARSET;
                           Cursor.Font.Size:=FontList[I].Size;
                           Cursor.AutoSize:=true;
                           FontIndex:=I
                         end
                    else begin
                           FontDialog1.Font:=Cursor.Font;
                           FontDialog1.Font.Style:=[];
                           FontDialog1.Font.Color:=clBlack;
                           S:=IntToStr(0  { Cursor.Width } );
                           if not FontDialog1.Execute then exit;
                           if not InputQuery('CELL WIDTH',
                                             'enter cell width (0=auto, or 8..32)', S) then exit;

                           case MessageDlg('force codepage 437 (OEM/DOS) ?',
                                           mtConfirmation, [mbYes, mbNo], 0)
                               of mrYes:OEM:=true;
                                   mrNo:OEM:=false
                               else     exit
                           end;

                           S:=trim(S);
                           try
                             I:=abs(StrToInt(S));
//                           OEM:=(S[1]='-');                  // force OEM if -ve size
                             if I in [0, 8..32] then
                             begin
                               Cursor.AutoSize:=true;
                               Cursor.Font.Name:=FontDialog1.Font.Name;
                               if OEM then Cursor.Font.Charset:=OEM_CHARSET
                                      else Cursor.Font.Charset:=FontDialog1.Font.Charset;
                               Cursor.Font.Size:=FontDialog1.Font.Size;
                               if I=0 then begin
                                             S:=Cursor.Caption;        // save cursor character
                                             for J:=32 to 126 do       // (space to tilde)
                                             begin
                                               Cursor.Caption:=chr(J);
                                               if J<>ord('@') then I:=max(I, Cursor.Width)
                                             end;                      // exclude @ symbol
                                             Cursor.Caption:=S         // restore cursor character
                                           end;
                               Cursor.AutoSize:=false;
                               if fsUnderline in FontDialog1.Font.Style then Cursor.Height:=Cursor.Height+1;
                               Cursor.Width:=max(I, 8);        // must be at least 8 pixels wide
                               FontIndex:=0
                             end
                           except exit end
                         end;

    Image1.Picture.Bitmap.Width:=Cursor.Width*COLS;            // set width
    Image1.Picture.Bitmap.Height:=Cursor.Height*ROWS;          // set height

    Image2.Picture.Bitmap.Width:=Cursor.Width*COLS;            // set width
    Image2.Picture.Bitmap.Height:=Cursor.Height*ROWS;          // set height

    Shape1.Width:=Cursor.Width*COLS           +4;
    Shape1.Height:=Cursor.Height*ROWS         +4;

    SCR.Font:=Cursor.Font;                           // copy font details from cursor

    clear(1, 1, COLS, ROWS);                         // clear text layer
    GFXclear(0, 0, Gw, Gh);                          // clear graphics layer
    gotoxy(1,1);                                     // home cursor

    Reg:=TRegistry.Create;
    with Reg do                          // save font size into registry
    begin
      RootKey:=HKEY_CURRENT_USER;
      try
        if OpenKey(SoftwareKey, true) then
        begin
//        WriteString('FontName', CSR.Font.Name);
//        WriteInteger('FontCSet', CSR.Font.Charset);
          if FontIndex in [1..10] then begin
                                         WriteInteger('FontIndex', FontIndex);
                                         DeleteValue('FontInfo');
                                         DeleteValue('FontSize')
                                       end
                                  else begin
                                         WriteInteger('FontIndex', 0);
                                         WriteString('FontInfo', '"'+Cursor.Font.Name+'", '+
                                                      IntToStr(Cursor.Font.Charset)+', '+
                                                      IntToStr(Cursor.Font.Size)+', '+
                                                      IntToStr(Cursor.Width));
                                         DeleteValue('FontSize')
                                       end
        end
      except end;
      try CloseKey except end
    end;
    Reg.Free
  end
end;


// popup menu item - select default text colour
procedure TForm1.Item5Click(Sender: TObject);
var Reg:TRegistry;
     TC:integer;
begin
  if Sender=Item5A then TC:=1 else
  if Sender=Item5B then TC:=2 else
  if Sender=Item5C then TC:=3 else
  if Sender=Item5D then TC:=4 else
  if Sender=Item5E then TC:=5 else
  if Sender=Item5F then TC:=6 else
  if Sender=Item5G then TC:=7
                   else TC:=-1;
  if TC<>-1 then
  begin
    FGdefault:=TC;
    FGcolour:=TC;

    Reg:=TRegistry.Create;
    with Reg do                        // save default FG colour into registry
    begin
      RootKey:=HKEY_CURRENT_USER;
      try
        if OpenKey(SoftwareKey, true) then WriteInteger('DefaultFG', FGdefault)
      except end;
      try CloseKey except end
    end;
    Reg.Free
  end
end;


// popup menu item - select how dim attribute is handled (8 vs 16 colour mode)
procedure TForm1.Item6Click(Sender: TObject);
var Reg:TRegistry;
     TD:integer;
begin

  if Sender=Item6A then TD:=0 else                     // dim attribute enabled
  if Sender=Item6B then TD:=1 else                     // force bright 1
  if Sender=Item6C then TD:=2                          // force bright 2
                   else TD:=-1;
  if TD<>-1 then
  begin
    Dimopt:=TD;

    Reg:=TRegistry.Create;
    with Reg do                        // save dim option into registry
    begin
      RootKey:=HKEY_CURRENT_USER;
      try
        if OpenKey(SoftwareKey, true) then WriteInteger('DimOption', DimOpt)
      except end;
      try CloseKey except end
    end;
    Reg.Free
  end
end;


// popup menu item - clear GFX plane / text plane / ring buffer
procedure TForm1.Item7Click(Sender: TObject);
begin
  if Sender=Item7A then begin
                          GFXclear(0, 0, Gw, Gh);      // clear graphics layer
                          Image2.Hide                  // hide graphics layer
                        end else
  if Sender=Item7B then clear(1, 1, COLS, ROWS) else   // clear text layer
  if Sender=Item7C then RB.head:=RB.tail               // clear ring buffer
end;


// popup menu item - show copy memo
procedure TForm1.Item8Click(Sender: TObject);
var X, Y:integer;
       S:string;
      TR:TRect;
begin
{
  if FGcolour=0 then Memo1.Font.Color:=CVT[15]
                else Memo1.Font.Color:=CVT[FGcolour or 8];
  Memo1.Color:=CVT[BGcolour];
}
  Memo1.Width:=Cursor.Width*COLS;
  Memo1.Height:=Cursor.Height*ROWS;

  Memo1.Font:=Cursor.Font;
  Memo1.Font.Style:=[];
  Memo1.Font.Color:=clBlack;                   // black text on a
  Memo1.Color:=clSilver;                       // silver background

  Memo1.Lines.Clear;                           // ensure memo is completely blank

  for Y:=1 to ROWS do                          // fill in memo text
  begin
    S:=StringOfChar(' ', COLS);                // blank line of 80 chars
    for X:=1 to COLS do
    begin
      S[X]:=TextStore[Y, X];                   // copy text from buffer (TextStore)
      if S[X]<' ' then S[X]:=' '               // turn control chars into whitespace
    end;
    S:=TrimRight(S);
    Memo1.Lines.Add(S)                         // transfer completed line into memo
  end;

  S:=Memo1.Text;
  S:=copy(S, 1, length(S)-2);                  // remove final CR-LF from memo
  Memo1.Text:=S;

  TR:=Memo1.ClientRect;                                        // get rid of
  SendMessage(Memo1.Handle, EM_SETRECT, 0, integer(@TR));      // those pesky
  Memo1.Invalidate;                                            // margins!!!

  Form1.PopupMenu:=nil;                        // disable our popup menu
                                               // (cut/copy menu takes over)
  Memo1.Enabled:=true;
  Memo1.Visible:=true
end;


// popup menu item - make command window visible
procedure TForm1.Item9Click(Sender: TObject);
begin
  Form2.Visible:=true;
  Form2.BringToFront
end;


procedure TForm1.ApplicationEvents1Activate(Sender: TObject);
begin
  Image3.Hide;
  ACTIVATED:=true
end;


procedure TForm1.ApplicationEvents1Deactivate(Sender: TObject);
begin

  Image3.Left:=Image1.Left+Image1.Width-Image3.Width;
  Image3.Top:=Image1.Top;
  Image3.Show;
  ACTIVATED:=false
end;


end.
